// External Dependencies
import React, {Component, Fragment} from 'react';
import axios from 'axios';
// Internal Dependencies
import './style.css';


class Booked extends Component {

  static slug = 'et_pb_booked_calendar';


    constructor(props)
    {
        super(props);


           this.state = {
               style:''
           };


    }

    componentDidMount() {
        this.getStyle();
    }

    componentWillReceiveProps(nextProps) {
        this.props = nextProps;
        this.getStyle();
    }

    getStyle() {

       axios.get(this.props.css_url, {
           params: {
               id: this.props.calendar_code_id,
               calendarFont: this.props.calendar_main_font,
               monthRowFont: this.props.month_row_font,
               dayRowFont: this.props.day_row_font,
               normalDayCellFont: this.props.normal_day_cell_font,
               normalDayCellFontColor: this.props.normal_day_cell_font_color,
               activeDayCellFontColor: this.props.active_day_cell_font_color,
               activeDayCellFont: this.props.active_day_cell_font,
               buttonFont: this.props.button_font,
               monthRowFontColor: this.props.month_row_font_color,
               calendarColor: this.props.calendar_main_color,
               calendarFontColor: this.props.calendar_main_font_color,
               monthRowColor: this.props.month_row_color,
               dayRowColor: this.props.day_row_color,
               dayRowFontColor: this.props.day_row_font_color,
               buttonBeforeColor: this.props.button_before_color,
               buttonFontColor: this.props.button_font_color,
               buttonAfterColor: this.props.button_after_color,
               hoverDayCellColor: this.props.hover_day_cell_color,
               normalDayCellColor: this.props.normal_day_cell_color,
               activeDayCellColor: this.props.active_day_cell_color,
           }
       }).then(response => (this.setState({style: response.data})));

       this.forceUpdate();

    }

    render() {
      return (
          <Fragment>

              <style>{this.state.style}</style>
          <div dangerouslySetInnerHTML={{__html:this.props.calendar_code}}></div>
          </Fragment>
              );
  }
}

export default [Booked];
