// External Dependencies
import React, {Component, Fragment} from 'react';
import axios from "axios/index";

class Agent extends Component {

  static slug = 'et_pb_booked_agent';

    constructor(props) {
        super(props);

        this.state = {
            style: ""
        };
    }

    componentDidMount() {
        this.getStyle();

    }

    componentWillReceiveProps(nextProps) {
        this.props = nextProps;
        this.getStyle();
    }

    getStyle() {

        axios.get(this.props.css_url, {
            params: {
                button_color:   this.props.button_color,
                main_color:     this.props.main_color,
                second_color:   this.props.second_color,
                background_color:   this.props.background_color,
                header_font: this.props.header_font,
                body_font:  this.props.body_font,
                header_font_color: this.props.header_font_color,
                body_font_color: this.props.body_font_color
            }
        }).then(response => (this.setState({style: response.data})));
        //console.log(this.props.style);
        this.forceUpdate();

    }

  render() {
 
    return (
        <Fragment>
        <style>{this.state.style}></style>
      <div dangerouslySetInnerHTML={{__html: this.props.agent_code}}></div>
        </Fragment>
    );
  }
}

export default [Agent];
