<?php

/**
 * Define the internationalization functionality
 *
 * Loads and defines the internationalization files for this plugin
 * so that it is ready for translation.
 *
 * @link       http://ecrosio.com
 * @since      1.0.0
 *
 * @package    Ecrosio_Rescal
 * @subpackage Ecrosio_Rescal/includes
 */

/**
 * Define the internationalization functionality.
 *
 * Loads and defines the internationalization files for this plugin
 * so that it is ready for translation.
 *
 * @since      1.0.0
 * @package    Ecrosio_Rescal
 * @subpackage Ecrosio_Rescal/includes
 * @author     egortar <y.tarkovskyi@ecrosio.com>
 */
class Ecrosio_Rescal_i18n {

    /**
     * Load the plugin text domain for translation
     *
     * @since 1.0.0
     */

    public function load_plugin_textdomain() {
        load_plugin_textdomain(
            'Ecrosio-Rescal',
            false,
            dirname( dirname( plugin_basename( __FILE__ ) ) ) . '/languages/'
        );
    }
}