<?php

/**
 * Runs during the plugin activation.
 *
 * @link        http://ecrosio.com
 * @since       1.0.0
 *
 * @package     Ecrosio_Rescal
 * @subpackage  Ecrosio_Rescal/includes
 */


/**
 * Runs on plugin activation.
 *
 * Defines all the functions that are necessary to run during plugin's activation.
 *
 * @since       1.0.0
 * @package     Ecrosio_Rescal
 * @subpackage  Ecrosio_Rescal/includes
 * @author      egortar <y.tarkovskyi@ecrosio.com>
 */
class Ecrosio_Rescal_Activator {

    /**
     * Runs on plugin activation from WP menu
     */
    public static function activate() {
        global $wpdb;
        $db_name = $wpdb->prefix . 'rescal_reservations';

        if ( ! file_exists( plugin_dir_path( dirname( __FILE__ ) ) . 'data/calendars.json' ) ) {
            touch( plugin_dir_path( dirname( __FILE__ ) ) . 'data/calendars.json' );
        }
    }
}