<?php

/**
 * The file that defines userHandler class which is used to handle multiple users data and functions.
 *
 * Class definition that includes attributes and function used for users handling functionality
 *
 * @link        http://ecrosio.com
 * @since       1.0.0
 *
 * @package     Ecrosio_Rescal
 * @subpackage  Ecrosio_Rescal/core
 */

/**
 * User handler class.
 *
 * This is used to handle users data and override standard WordPress users functionality.
 *
 * @since       1.0.0
 * @package     Ecrosio_Rescal
 * @subpackage  Ecrosio_Rescal/core
 * @author      egortar <y.tarkovskyi@ecrosio.com>
 */
class Ecrosio_Rescal_UserHandler {

    /**
     * Ecrosio_Rescal_UserHandler constructor.
     */
    function __construct() {
    }

    /**
     * Override for WordPress standard function. Gets user info by ID.
     *
     * @since 1.0.0
     *
     * @param $id int Selected user ID.
     *
     * @return mixed List of selected user's data.
     */
    function getUserInfo( $id ) {
        $user_info = get_userdata( $id );

        return $user_info;
    }

    /**
     * Create new User object with provided data.
     *
     * @since 1.0.0
     *
     * @param $data array List of user's data fields.
     *
     * @return Ecrosio_Rescal_User Created user object.
     */
    function createUser( $data ) {
        $user = new Ecrosio_Rescal_User( $data['id'], $data['login'], $data['password'], $data['nicename'], $data['mail'], $data['registered'], $data['display_name'], $data['first_name'], $data['last_name'], $data['nickname'], $data['description'] );

        return $user;
    }

    /**
     * Get's current user information
     *
     * @return int Current user id.
     */
    function getCurrentUserID() {
        $id = get_current_user_id();

        return $id;
    }
}