<?php

/**
 * The file that defines User class which is used to store user data and functions.
 *
 * Class definition that includes attributes and function used for user definition class.
 *
 * @link        http://ecrosio.com
 * @since       1.0.0
 *
 * @package     Ecrosio_Rescal
 * @subpackage  Ecrosio_Rescal/core
 */

/**
 * User handler class.
 *
 * This is used to handle user's data and functions.
 *
 * @since       1.0.0
 * @package     Ecrosio_Rescal
 * @subpackage  Ecrosio_Rescal/core
 * @author      egortar <y.tarkovskyi@ecrosio.com>
 */
class Ecrosio_Rescal_User {

    /**
     * @since 1.0.0
     * @access protected
     * @var int $id User's unique ID.
     */
    protected $id;

    /**
     * @since 1.0.0
     * @access protected
     * @var string $login User's unique login.
     */
    protected $login;

    /**
     * @since 1.0.0
     * @access protected
     * @var string $password User's password.
     */
    protected $password;

    /**
     * @since 1.0.0
     * @access protected
     * @var string $nicename User's url-sanitized version of $login.
     */
    protected $nicename;

    /**
     * @since 1.0.0
     * @access protected
     * @var string $email User's e-mail address.
     */
    protected $email;

    /**
     * @since 1.0.0
     * @access protected
     * @var boolean $registered Flag of user's registration status.
     */
    protected $registered;

    /**
     * @since 1.0.0
     * @access protected
     * @var string $display_name User's display name.
     */
    protected $display_name;


    /**
     * @since 1.0.0
     * @access protected
     * @var string $first_name User's first name.
     */
    protected $first_name;

    /**
     * @since 1.0.0
     * @access protected
     * @var string $last_name User's last name.
     */
    protected $last_name;

    /**
     * @since 1.0.0
     * @access protected
     * @var string $nickname User's last nickname.
     */
    protected $nickname;

    /**
     * @since 1.0.0
     * @access protected
     * @var string $description User's description.
     */
    protected $description;

    /**
     * Ecrosio_Rescal_User constructor.
     *
     * @since 1.0.0
     *
     * @param $id           int     User's unique ID.
     * @param $login        string  User's unique login name.
     * @param $password     string  User's password.
     * @param $nicename     string  User's url-sanitized version of $login.
     * @param $mail         string  User's e-mail.
     * @param $registered   boolean User's registration status flag.
     * @param $display_name string  User's display name.
     * @param $first_name   string  User's first name.
     * @param $last_name    string  User's last name.
     * @param $nickname     string  User's nickname.
     * @param $description  string  User's description.
     */
    function __construct( $id, $login, $password, $nicename, $mail, $registered, $display_name, $first_name, $last_name, $nickname, $description ) {

        $this->id           = $id;
        $this->login        = $login;
        $this->password     = $password;
        $this->nicename     = $nicename;
        $this->email        = $mail;
        $this->registered   = $registered;
        $this->display_name = $display_name;
        $this->first_name   = $first_name;
        $this->last_name    = $last_name;
        $this->nickname     = $nickname;
        $this->description  = $description;
    }

    /**
     * User's class getter.
     *
     * @since 1.0.0
     *
     * @param $property string Property's name.
     *
     * @return mixed Property's value.
     */
    public function __get( $property ) {
        if ( property_exists( $this, $property ) ) {
            return $this->$property;
        }
    }

    /**
     * User's class setter.
     *
     * @param $property string  Property's name.
     * @param $value    mixed   Property's new value.
     *
     * @return $this Ecrosio_Rescal_User User's class instance.
     */
    public function __set( $property, $value ) {
        if ( property_exists( $this, $property ) ) {
            $this->$property = $value;
        }

        return $this;
    }
}