<?php

/**
 * The file that contains shortcode handler manager.
 *
 * Class definition that helps to add, modify and handle WordPress
 * shortcodes.
 *
 * @link        http://ecrosio.com
 * @since       1.0.0
 *
 * @package     Ecrosio_Rescal
 * @subpackage  Ecrosio_Rescal/core
 */

/**
 * Shortcode handler class.
 *
 * Class definition that helps to add, modify and handle WordPress
 * shortcodes.
 *
 * @since       1.0.0
 * @package     Ecrosio_Rescal
 * @subpackage  Ecrosio_Rescal/core
 * @author      egortar <y.tarkovskyi@ecrosio.com>
 */
class Ecrosio_Rescal_ShortcodeManager {

    /**
     * List of the plugin's shortcodes
     *
     * @since   1.0.0
     * @access  protected
     * @var     array $shortcode_list List of the plugin's shortcodes names and functions.
     */
    protected $shortcode_list;

    /**
     * Load dependencies and initialize variables.
     *
     * @since 1.0.0
     */
    public function __construct() {
        //TODO: load shortcodes from file
        $this->shortcode_list = array();
    }

    /**
     * Add new shortcode and register it with the WordPress.
     *
     * @since 1.0.0
     *
     * @param $name     string Name of the shortcode.
     * @param $function mixed Shortcode function name.
     */
    public function rescal_add_shortcode( $name, $function ) {

        if ( ! shortcode_exists( $name ) ) {
            array_push( $this->shortcode_list, array( $name => $function ) );
            add_shortcode( $name, $function );
        }
    }

    /**
     * Delete existing shortcode by it's tag.
     *
     * @since 1.0.0
     *
     * @param $tag      string Name of the shortcode to remove.
     */
    public function rescal_remove_shortcode( $tag ) {

        unset( $this->shortcode_list[ $tag ] );
        remove_shortcode( $tag );
    }

}