<?php

/**
 * The file that defines the core calendar's functionality that is not connected to the DIVI.
 *
 * Class definition that includes attributes and function used for calendar's main
 * functionality.
 *
 * @link        http://ecrosio.com
 * @since       1.0.0
 *
 * @package     Ecrosio_Rescal
 * @subpackage  Ecrosio_Rescal/core
 */

/**
 * The core calendar class.
 *
 * This is used to define and include all calendar's core functions and
 * dependencies. The core class isn't connected with DIVI PageBuilder
 * for flexibility reasons.
 *
 * @since       1.0.0
 * @package     Ecrosio_Rescal
 * @subpackage  Ecrosio_Rescal/core
 * @author      egortar <y.tarkovskyi@ecrosio.com>
 */
class Ecrosio_Rescal_Core {

    /**
     * Current version of the plugin.
     *
     * @since   1.0.0
     * @access  protected
     * @var     string $version The current version of the plugin.
     */
    protected $version;

    /**
     * Shortcode manager
     *
     * @since   1.0.0
     * @access  protected
     * @var     Ecrosio_Rescal_ShortcodeManager Shortcode manager
     */
    protected $shortcodeManager;

    /**
     * Plugin's mailer
     *
     * @since   1.0.0
     * @access  protected
     * @var     Ecrosio_Rescal_Mailer Plugin's mail manager
     */
    protected $mailer;

    /**
     * @var Ecrosio_Rescal_Calendar calendar's class
     */
    protected $calendar;

    /**
     * Define the core functionality.
     *
     * Load dependencies and set default values.
     *
     * @since 1.0.0
     */
    public function __construct() {

        $this->load_dependencies();

        $this->shortcodeManager->rescal_add_shortcode( 'rescal-calendar', array( $this->calendar, 'show' ) );
    }

    /**
     * Load the required dependencies for calendar's functionality.
     *
     * @since   1.0.0
     * @access  private
     */
    private function load_dependencies() {
        /**
         * Handle plugin's shortcodes
         */
        require_once plugin_dir_path( dirname( __FILE__ ) ) . 'core/class-ecrosio-rescal-shortcodeManager.php';


        $this->shortcodeManager = new Ecrosio_Rescal_ShortcodeManager();
    }

    /**
     * Retrieve the version number of the plugin.
     *
     * @since     1.0.0
     * @return    string    The version number of the plugin.
     */
    public function get_version() {
        return $this->version;
    }

    /**
     * Get instance of shortcode manager
     *
     * @since   1.0.0
     * @return  Ecrosio_Rescal_ShortcodeManager Instance of shortcode manager
     */
    public function get_shortcodeManager() {
        return $this->shortcodeManager;
    }

    /**
     * Get instance of plugin's mailer
     *
     * @since   1.0.0
     * @return  Ecrosio_Rescal_Mailer    Instance of plugin's mail manager
     */
    public function get_mailer() {
        return $this->mailer;
    }
}