<?php

/**
 * Created by PhpStorm.
 * User: egortar
 * Date: 26.07.2017
 * Time: 23:11
 */
class GWP_Custom_Module_BookedCalendar extends ET_Builder_Module {

    private $settings;
    private $default_values;

    public $vb_support = 'on';
    public $fb_support = true;
    public $slug = 'et_pb_booked_calendar';


    public function init()
    {
        $this->name = esc_html__('Booked Calendar', 'et_builder');
        $this->slug = 'et_pb_booked_calendar';

        $this->settings       = array();
        $this->default_values = array();

        $this->CalendarSelectorOptions = array();
        $calendars                     = get_terms(
            'booked_custom_calendars',
            array(
                'orderby'    => 'name',
                'order'      => 'ASC',
                'hide_empty' => false
            )
        );

        foreach ($calendars as $cal) {
            array_push($this->CalendarSelectorOptions,  $cal->name);
        }

        array_push($this->CalendarSelectorOptions, 'Default Calendar');

        $this->whitelisted_fields = array(
            'calendar_selector',
            'calendar_color',
            'month_row_color',
            'day_row_color',
            'button_before_color',
            'button_after_color',
            'active_day_cell_color',
            'normal_day_cell_color',
            'hover_day_cell_color',
            'calendar_font',
            'calendar_font_color',
            'month_row_font',
            'month_row_font_color',
            'day_row_font',
            'day_row_font_color',
            'normal_day_cell_font',
            'normal_day_cell_font_color',
            'active_day_cell_font',
            'active_day_cell_font_color',
            'button_font',
            'button_font_color',
            'admin_label',
            'calendar_code',
            'calendar_code_id'
        );
        require_once plugin_dir_path(dirname(__FILE__)).'core/class-ecrosio-rescal-core.php';
        $this->fields_defaults = array(
            'calendar_selector'          => 0,
            'calendar_main_color'        => "#423123",
            'calendar_main_font'         => "Roboto",
            'calendar_color'             => '#ffffff',
            'month_row_color'            => '#C4F2D4',
            'day_row_color'              => '#c4f2d4',
            'button_before_color'        => '#CAEBD5',
            'button_after_color'         => '#C4F2D4',
            'active_day_cell_color'      => '#ffffff',
            'normal_day_cell_color'      => '#F5F5F5',
            'hover_day_cell_color'       => '#ffffff',
            'calendar_font'              => 'Roboto',
            'calendar_font_color'        => '#000000',
            'month_row_font'             => 'Roboto',
            'month_row_font_color'       => '#000000',
            'day_row_font'               => 'Roboto',
            'day_row_font_color'         => '#000000',
            'normal_day_cell_font'       => 'Roboto',
            'normal_day_cell_font_color' => '#000000',
            'active_day_cell_font'       => 'Roboto',
            'active_day_cell_font_color' => '#000000',
            'button_font'                => 'Roboto',
            'button_font_color'          => '#000000',
            'admin_label'                => 'Booked-Calendar',
            'calendar_code'              => '',
            'calendar_code_id'           => '',
            'css_url'                    => BOOKED_PLUGIN_URL.'/assets/css/style_react.php',
        );

        $this->advanced_options   = array();
        $this->custom_css_options = array();
        $this->main_css_element   = '%%order_class%%';

    }


    public function get_fields() {

        $fields = array(
            'calendar_selector'          => array(
                'label'           => esc_html__( 'Select calendar', 'et_builder' ),
                'type'            => 'select',
                'options'         => $this->CalendarSelectorOptions,
                'option_category' => 'configuration',
                'default'         => $this->fields_defaults['calendar_selector'],
                'description'     => esc_html__( 'Select Calendar To Add', 'et_builder' ),
            ),
            'calendar_main_color'        => array(
                'label'           => esc_html__( 'Calendar Background Color', 'et_builder' ),
                'type'            => 'color',
                'option_category' => 'configuration',
                'default'         => $this->fields_defaults['calendar_main_color'],
                'description'     => esc_html__( 'This will adjust the color of the calendar background.', 'et_builder' ),
            ),
            'calendar_main_font'         => array(
                'label'           => esc_html__( 'Calendar Main Font', 'et_builder' ),
                'type'            => 'font',
                'option_category' => 'configuration',
                'default'         => $this->fields_defaults['calendar_main_font'],
                'description'     => esc_html__( 'Calendar main font', 'et_builder' ),
            ),
            'calendar_main_font_color'   => array(
                'label'           => esc_html__( 'Calendar Main Font Color', 'et_builder' ),
                'type'            => 'color-alpha',
                'option_category' => 'configuration',
                'default'         => $this->fields_defaults['calendar_font_color'],
                'description'     => esc_html__( 'Calendar main font color', 'et_builder' ),
            ),
            'month_row_color'            => array(
                'label'           => esc_html__( 'Month Row Color', 'et_builder' ),
                'type'            => 'color-alpha',
                'option_category' => 'configuration',
                'default'         => $this->fields_defaults['month_row_color'],
                'description'     => esc_html__( 'This will adjust the color of calendar\'s month row.', 'et_builder' ),
            ),
            'month_row_font'             => array(
                'label'           => esc_html__( 'Month Row Font', 'et_builder' ),
                'type'            => 'font',
                'option_category' => 'configuration',
                'default'         => $this->fields_defaults['month_row_font'],
                'description'     => esc_html__( 'Month Row Font', 'et_builder' ),
            ),
            'month_row_font_color'       => array(
                'label'           => esc_html__( 'Month Row Font Color', 'et_builder' ),
                'type'            => 'color-alpha',
                'option_category' => 'configuration',
                'default'         => $this->fields_defaults['month_row_font_color'],
                'description'     => esc_html__( 'Month Row Font Color', 'et_builder' ),
            ),
            'day_row_color'              => array(
                'label'           => esc_html__( 'Day Row Color', 'et_builder' ),
                'type'            => 'color-alpha',
                'option_category' => 'configuration',
                'default'         => $this->fields_defaults['day_row_color'],
                'description'     => esc_html__( 'This will adjust the color of calendar\'s days row.', 'et_builder' ),
            ),
            'day_row_font'               => array(
                'label'           => esc_html__( 'Day Row Font', 'et_builder' ),
                'type'            => 'font',
                'option_category' => 'configuration',
                'default'         => $this->fields_defaults['day_row_font'],
                'description'     => esc_html__( 'Day Row Font', 'et_builder' ),
            ),
            'day_row_font_color'         => array(
                'label'           => esc_html__( 'Day Row Font Color', 'et_builder' ),
                'type'            => 'color-alpha',
                'option_category' => 'configuration',
                'default'         => $this->fields_defaults['day_row_font_color'],
                'description'     => esc_html__( 'Day Row Font Color', 'et_builder' ),
            ),
            'normal_day_cell_color'      => array(
                'label'           => esc_html__( 'Normal Day Cell Color', 'et_builder' ),
                'type'            => 'color-alpha',
                'option_category' => 'configuration',
                'default'         => $this->fields_defaults['normal_day_cell_color'],
                'description'     => esc_html__( 'This will adjust the color of normal (non-active) day cell', 'et_builder' ),
            ),
            'normal_day_cell_font'       => array(
                'label'           => esc_html__( 'Normal Day Cell Font', 'et_builder' ),
                'type'            => 'font',
                'option_category' => 'configuration',
                'default'         => $this->fields_defaults['normal_day_cell_font'],
                'description'     => esc_html__( 'Normal (non-active) day\'s cell font', 'et_builder' ),
            ),
            'normal_day_cell_font_color' => array(
                'label'           => esc_html__( 'Normal Day Cell Font Color', 'et_builder' ),
                'type'            => 'color-alpha',
                'option_category' => 'configuration',
                'default'         => $this->fields_defaults['normal_day_cell_font_color'],
                'description'     => esc_html__( 'Normal (non-active) day\'s cell font color', 'et_builder' ),
            ),
            'hover_day_cell_color'       => array(
                'label'           => esc_html__( 'Day Cell Hover Color', 'et_builder' ),
                'type'            => 'color-alpha',
                'option_category' => 'configuration',
                'default'         => $this->fields_defaults['hover_day_cell_color'],
                'description'     => esc_html__( 'This will adjust the day cell\'s hover', 'et_builder' ),
            ),
            'active_day_cell_color'      => array(
                'label'           => esc_html__( 'Active Day Cell Color', 'et_builder' ),
                'type'            => 'color-alpha',
                'option_category' => 'configuration',
                'default'         => $this->fields_defaults['active_day_cell_color'],
                'description'     => esc_html__( 'This will adjust the color of active day cell', 'et_builder' ),
            ),
            'active_day_cell_font'       => array(
                'label'           => esc_html__( 'Active Day Cell Font', 'et_builder' ),
                'type'            => 'font',
                'option_category' => 'configuration',
                'default'         => $this->fields_defaults['active_day_cell_font'],
                'description'     => esc_html__( 'Active day\'s cell font', 'et_builder' ),
            ),
            'active_day_cell_font_color' => array(
                'label'           => esc_html__( 'Active Day Cell Font Color', 'et_builder' ),
                'type'            => 'color-alpha',
                'option_category' => 'configuration',
                'default'         => $this->fields_defaults['active_day_cell_font_color'],
                'description'     => esc_html__( 'Active day\'s cell font color', 'et_builder' ),
            ),
            'button_before_color'        => array(
                'label'           => esc_html__( 'Button Color (before click)', 'et_builder' ),
                'type'            => 'color-alpha',
                'option_category' => 'configuration',
                'default'         => $this->fields_defaults['button_before_color'],
                'description'     => esc_html__( 'This will adjust the color of the button before click', 'et_builder' ),
            ),
            'button_after_color'         => array(
                'label'           => esc_html__( 'Button Color (after click)', 'et_builder' ),
                'type'            => 'color-alpha',
                'option_category' => 'configuration',
                'default'         => $this->fields_defaults['button_after_color'],
                'description'     => esc_html__( 'This will adjust the color of the button after click', 'et_builder' ),
            ),
            'button_font'                => array(
                'label'           => esc_html__( 'Button Font', 'et_builder' ),
                'type'            => 'font',
                'option_category' => 'configuration',
                'default'         => $this->fields_defaults['buttonFont'],
                'description'     => esc_html__( 'Button font', 'et_builder' ),
            ),
            'button_font_color'          => array(
                'label'           => esc_html__( 'Button Font Color', 'et_builder' ),
                'type'            => 'color-alpha',
                'option_category' => 'configuration',
                'default'         => $this->fields_defaults['button_font_color'],
                'description'     => esc_html__( 'Button font Color', 'et_builder' ),
            ),
            'admin_label'                => array(
                'label'       => esc_html__( 'Admin Label', 'et_builder' ),
                'type'        => 'text',
                'description' => esc_html__( 'This will change the label of the module in the builder for easy identification.', 'et_builder' ),
            ),
            'module_id'                  => array(
                'label'           => esc_html__( 'CSS ID', 'et_builder' ),
                'type'            => 'text',
                'option_category' => 'configuration',
                'tab_slug'        => 'custom_css',
                'option_class'    => 'et_pb_custom_css_regular',
            ),
            'module_class'               => array(
                'label'           => esc_html__( 'CSS Class', 'et_builder' ),
                'type'            => 'text',
                'option_category' => 'configuration',
                'tab_slug'        => 'custom_css',
                'option_class'    => 'et_pb_custom_css_regular',
            ),
            'calendar_code' => array(
                'label' => '',
                'type'  => "hidden"
            ),
            'calendar_code_id' => array(
                'label' => '',
                'type'  => "hidden"
            ),
            'css_url' => array(
                'label' => '',
                'type'  => ''
            )
        );

        return $fields;
    }

    public function before_render()
    {
        $atts = $this->props;

        $this->default_values = array(
            'calendar_selector'          => 0,
            'calendar_main_color'        => '#ffffff',
            'calendar_main_font'         => 'Roboto|||||',
            'calendar_main_font_color'   => '#000000',
            'month_row_color'            => '#C4F2D4',
            'month_row_font'             => 'Roboto|||||',
            'month_row_font_color'       => '#000000',
            'day_row_color'              => '#c4f2d4',
            'day_row_font'               => 'Roboto|||||',
            'day_row_font_color'         => '#000000',
            'normal_day_cell_color'      => '#F5F5F5',
            'normal_day_cell_font'       => 'Roboto|||||',
            'normal_day_cell_font_color' => '#000000',
            'hover_day_cell_color'       => '#000000',
            'active_day_cell_color'      => '#ffffff',
            'active_day_cell_font'       => 'Roboto|||||',
            'active_day_cell_font_color' => '#000000',
            'button_before_color'        => '#CAEBD5',
            'button_after_color'         => '#C4F2D4',
            'button_font'                => 'Roboto|||||',
            'button_font_color'          => '#000000',
            'admin_label'                => 'Booked-Calendar',
            'calendar_code'              => '',
            'css_url'          => BOOKED_PLUGIN_URL.'/assets/css/style_react.php',
        );


        $calendars = get_terms( 'booked_custom_calendars', array(
            'orderby'    => 'name',
            'order'      => 'ASC',
            'hide_empty' => false
        ) );

        $this->settings['calendar_selector']          = isset( $atts['calendar_selector'] ) ? $atts['calendar_selector'] : $this->default_values['calendar_selector'];
        $this->settings['calendar_main_color']        = isset( $atts['calendar_main_color'] ) ? $atts['calendar_main_color'] : $this->default_values['calendar_main_color'];
        $this->settings['calendar_main_font']         = isset( $atts['calendar_main_font'] ) ? $atts['calendar_main_font'] : $this->default_values['calendar_main_font'];
        $this->settings['calendar_main_font_color']   = isset( $atts['calendar_main_font_color'] ) ? $atts['calendar_main_font_color'] : $this->default_values['calendar_main_font_color'];
        $this->settings['month_row_color']            = isset( $atts['month_row_color'] ) ? $atts['month_row_color'] : $this->default_values['month_row_color'];
        $this->settings['month_row_font']             = isset( $atts['month_row_font'] ) ? $atts['month_row_font'] : $this->default_values['month_row_font'];
        $this->settings['month_row_font_color']       = isset( $atts['month_row_font_color'] ) ? $atts['month_row_font_color'] : $this->default_values['month_row_font_color'];
        $this->settings['day_row_color']              = isset( $atts['day_row_color'] ) ? $atts['day_row_color'] : $this->default_values['day_row_color'];
        $this->settings['day_row_font']               = isset( $atts['day_row_font'] ) ? $atts['day_row_font'] : $this->default_values['day_row_font'];
        $this->settings['day_row_font_color']         = isset( $atts['day_row_font_color'] ) ? $atts['day_row_font_color'] : $this->default_values['day_row_font_color'];
        $this->settings['normal_day_cell_color']      = isset( $atts['normal_day_cell_color'] ) ? $atts['normal_day_cell_color'] : $this->default_values['normal_day_cell_color'];
        $this->settings['normal_day_cell_font']       = isset( $atts['normal_day_cell_font'] ) ? $atts['normal_day_cell_font'] : $this->default_values['normal_day_cell_font'];
        $this->settings['normal_day_cell_font_color'] = isset( $atts['normal_day_cell_font_color'] ) ? $atts['normal_day_cell_font_color'] : $this->default_values['normal_day_cell_font_color'];
        $this->settings['hover_day_cell_color']       = isset( $atts['hover_day_cell_color'] ) ? $atts['hover_day_cell_color'] : $this->default_values['hover_day_cell_color'];
        $this->settings['active_day_cell_color']      = isset( $atts['active_day_cell_color'] ) ? $atts['active_day_cell_color'] : $this->default_values['active_day_cell_color'];
        $this->settings['active_day_cell_font']       = isset( $atts['active_day_cell_font'] ) ? $atts['active_day_cell_font'] : $this->default_values['active_day_cell_font'];
        $this->settings['active_day_cell_font_color'] = isset( $atts['active_day_cell_font_color'] ) ? $atts['active_day_cell_font_color'] : $this->default_values['active_day_cell_font_color'];
        $this->settings['button_before_color']        = isset( $atts['button_before_color'] ) ? $atts['button_before_color'] : $this->default_values['button_before_color'];
        $this->settings['button_after_color']         = isset( $atts['button_after_color'] ) ? $atts['button_after_color'] : $this->default_values['button_after_color'];
        $this->settings['button_font']                = isset( $atts['button_font'] ) ? $atts['button_font'] : $this->default_values['button_font'];
        $this->settings['button_font_color']          = isset( $atts['button_font_color'] ) ? $atts['button_font_color'] : $this->default_values['button_font_color'];
        $this->settings['admin_label']                = isset( $atts['admin_label'] ) ? $atts['admin_label'] : $this->default_values['admin_label'];
        $this->settings['module_id']                  = $this->shortcode_atts['module_id'];
        $this->settings['module_class']               = $this->shortcode_atts['module_class'];


        $nameSelected = $this->settings['calendar_selector'];
        $id           = '';

        foreach ( $calendars as $cal ) {
            if ( $cal->name == $nameSelected ) {
                $id = $cal->term_id;
            }
        }

        $local_time = current_time( 'timestamp' );
        $year       = date_i18n( 'Y', $local_time );
        $month      = date_i18n( 'm', $local_time );

        // $module_class = ET_Builder_Element::add_module_order_class( $this->settings['module_class'], $function_name );

        $calendar_main_font_array = explode( '|', $this->settings['calendar_main_font'] );
        $calendar_main_font_url   = str_replace( ' ', '+', $calendar_main_font_array[0] );

        $month_row_font_array = explode( '|', $this->settings['month_row_font'] );
        $month_row_font_url   = str_replace( ' ', '+', $month_row_font_array[0] );

        $day_row_font_array = explode( '|', $this->settings['day_row_font'] );
        $day_row_font_url   = str_replace( ' ', '+', $day_row_font_array[0] );

        $day_cell_normal_font_array = explode( '|', $this->settings['normal_day_cell_font'] );
        $day_cell_normal_font_url   = str_replace( ' ', '+', $day_cell_normal_font_array[0] );

        $day_cell_active_font_array = explode( '|', $this->settings['active_day_cell_font'] );
        $day_cell_active_font_url   = str_replace( ' ', '+', $day_cell_active_font_array[0] );

        $button_font_array = explode( '|', $this->settings['button_font'] );
        $button_font_url   = str_replace( ' ', '+', $button_font_array[0] );

        //Calendar Main Color



        $options = array();

        $rand = rand(0,999);

        $options[$id.'-calendarColor'] = isset( $atts['calendar_main_color'] ) ? $atts['calendar_main_color'] : $this->default_values['calendar_main_color'];
        $options[$id.'-monthRowColor'] = isset( $atts['month_row_color'] ) ? $atts['month_row_color'] : $this->default_values['month_row_color'];
        $options[$id.'-dayRowColor'] = isset( $atts['day_row_color'] ) ? $atts['day_row_color'] : $this->default_values['day_row_color'];
        $options[$id.'-buttonBeforeColor'] = isset( $atts['button_before_color'] ) ? $atts['button_before_color'] : $this->default_values['button_before_color'];
        $options[$id.'-buttonAfterColor'] = isset( $atts['button_after_color'] ) ? $atts['button_after_color'] : $this->default_values['button_after_color'];
        $options[$id.'-activeDayCellColor'] = isset( $atts['active_day_cell_color'] ) ? $atts['active_day_cell_color'] : $this->default_values['active_day_cell_color'];
        $options[$id.'-normalDayCellColor'] = isset( $atts['normal_day_cell_color'] ) ? $atts['normal_day_cell_color'] : $this->default_values['normal_day_cell_color'];
        $options[$id.'-calendarFontColor'] = isset( $atts['calendar_main_font_color'] ) ? $atts['calendar_main_font_color'] : $this->default_values['calendar_main_font_color'];
        $options[$id.'-monthRowFont'] = isset( $atts['month_row_font'] ) ? $atts['month_row_font'] : $this->default_values['month_row_font'];
        $options[$id.'-monthRowFontColor'] = isset( $atts['month_row_font_color'] ) ? $atts['month_row_font_color'] : $this->default_values['month_row_font_color'];
        $options[$id.'-dayRowFont'] = isset( $atts['day_row_font'] ) ? $atts['day_row_font'] : $this->default_values['day_row_font'];
        $options[$id.'-dayRowFontColor'] = isset( $atts['day_row_font_color'] ) ? $atts['day_row_font_color'] : $this->default_values['day_row_font_color'];
        $options[$id.'-normalDayCellFont'] = isset( $atts['normal_day_cell_font'] ) ? $atts['normal_day_cell_font'] : $this->default_values['normal_day_cell_font'];
        $options[$id.'-normalDayCellFontColor'] = isset( $atts['normal_day_cell_font_color'] ) ? $atts['normal_day_cell_font_color'] : $this->default_values['normal_day_cell_font_color'];
        $options[$id.'-activeDayCellFont'] = isset( $atts['active_day_cell_font'] ) ? $atts['active_day_cell_font'] : $this->default_values['active_day_cell_font'];
        $options[$id.'-activeDayCellFontColor'] = isset( $atts['active_day_cell_font_color'] ) ? $atts['active_day_cell_font_color'] : $this->default_values['active_day_cell_font_color'];
        $options[$id.'-buttonFont'] = isset( $atts['button_font'] ) ? $atts['button_font'] : $this->default_values['button_font'];
        $options[$id.'-buttonFontColor'] = isset( $atts['button_font_color'] ) ? $atts['button_font_color'] : $this->default_values['button_font_color'];
        $options[$id.'-adminLabel'] = isset( $atts['admin_label'] ) ? $atts['admin_label'] : $this->default_values['admin_label'];
        $options[$id.'-hoverDayCellColor'] = isset( $atts['hover_day_cell_color'] ) ? $atts['hover_day_cell_color'] : $this->default_values['hover_day_cell_color'];


        $output = booked_fe_calendar_divi( $year, $month, $id, false, $options, true);
        $style = " ";


        $calendarFontUrl = str_replace( ' ', '+', $options[$id.'-calendarFont']);
        $monthFontUrl = str_replace( ' ', '+', $options[$id.'-monthRowFont']);
        $dayFontUrl = str_replace( ' ', '+', $options[$id.'-dayRowFont']);
        $normalDayCellFontUrl = str_replace( ' ', '+', $options[$id.'-normalDayCellFont']);
        $activeDayCellFontUrl = str_replace( ' ', '+', $options[$id.'-activeDayCellFont']);
        $buttonFontUrl = str_replace( ' ', '+', $options[$id.'-buttonFont']);

        $calendarFont = explode('|', $options[$id.'-calendarFont']);
        $monthFont = explode( '|', $options[$id.'-monthRowFont']);
        $dayFont = explode( '|', $options[$id.'-dayRowFont']);
        $normalDayCellFont = explode( '|', $options[$id.'-normalDayCellFont']);
        $activeDayCellFont = explode( '|', $options[$id.'-activeDayCellFont']);
        $buttonFont = explode( '|', $options[$id.'-buttonFont']);


//echo '#test:before {content: "'.$options[$id.'-normalDayCellFontColor'].'";}';
        $style .= '#calendar'.$rand.' table.booked-calendar thead th .page-right, #calendar'.$rand.' table.booked-calendar thead th .page-left { color: '.$options[$id.'-monthRowFontColor'].'!important;}';
        $style .= '#calendar'.$rand.' .booked-form .booked-appointments{ background-color: '.$options[$id.'-calendarColor'].' !important; font-family: "'.$calendarFont[0].'" !important; color: '.$options[$id.'-calendarFontColor'].'!important;}';
        $style .= '#calendar'.$rand.' .booked-modal .bm-window .booked-scrollable  { background-color: '.$options[$id.'-calendarColor'].' !important; font-family: "'.$calendarFont[0].'" !important; color: '.$options[$id.'-calendarFontColor'].'!important;}';
        $style .= '#calendar'.$rand.' .booked-calendar-wrap .booked-appt-list h2 {font-family: "'.$calendarFont[0].'" !important; color: '.$options[$id.'-calendarFontColor'].'!important;}';
        $style .= '#calendar'.$rand.' .booked-calendar-wrap .booked-appt-list .timeslot .timeslot-time, #calendar'.$rand.' .booked-calendar-wrap .booked-appt-list .timeslot .spots-available {font-family: "'.$calendarFont[0].'" !important; color: '.$options[$id.'-calendarFontColor'].'!important;}';
        $style .= '#calendar'.$rand.' table.booked-calendar td.today .date span {border: 2px solid '.$options[$id.'-hoverDayCellColor'].';color:#000 !important;}';

        /*
        $style .= '#calendar'.$rand.' table.booked-calendar .monthRow {border-color: '.$options[$id.'-m'].' !important; background-color: '.$options[$id.'-calendarColor'].' !important; font-family: '.$options[$id.'-calendarColor'].' !important; color:  '.$options[$id.'-calendarColor'].' !important;}';
        */
        $style .= '#calendar'.$rand.' table.booked-calendar tr.month-'.$id.' th{ border-color: '.$options[$id.'-monthRowColor'].' !important;background-color: '.$options[$id.'-monthRowColor'].' !important; font-family: '.$monthFont[0].' !important; color: '.$options[$id.'-monthRowFontColor'].'!important;}';

        $style .= '#calendar'.$rand.' table.booked-calendar tr.days-'.$id.' th{ border-color: '.$options[$id.'-dayRowColor'].' !important;background-color: '.$options[$id.'-dayRowColor'].' !important; font-family: "'.$dayFont[0].'" !important;font-family: "'.$dayFont[0].'" !important; color: '.$options[$id.'-dayRowFontColor'].'!important;}';
        $style .= '#calendar'.$rand.' table.booked-calendar .booked-appt-list .timeslot .timeslot-people button#book-button-'.$id.'{ border-color: '.$options[$id.'-buttonBeforeColor'].' !important ;  background-color: '.$options[$id.'-buttonBeforeColor'].' !important ; font-family: "'.$buttonFont[0].'" !important; color: '.$options[$id.'-buttonFontColor'].'!important;}';
        $style .= '#calendar'.$rand.' table.booked-calendar .booked-appt-list .timeslot .timeslot-people button#book-button-'.$id.':hover{ border-color: '.$options[$id.'-buttonAfterColor'].' !important ;  background-color: '.$options[$id.'-buttonAfterColor'].' !important ;}';


        $style .= '#calendar'.$rand.' .booked-modal input[type=submit]#submit-request-appointment-'.$id.'{ border-color: '.$options[$id.'-buttonBeforeColor'].' !important ;  background-color: '.$options[$id.'-buttonBeforeColor'].' !important ; font-family: "'.$buttonFont[0].'" !important; color: '.$options[$id.'-buttonFontColor'].'!important;}';
        $style .= '#calendar'.$rand.' .booked-modal input[type=submit]#submit-request-appointment-'.$id.':hover{ border-color: '.$options[$id.'-buttonAfterColor'].' !important ;  background-color: '.$options[$id.'-buttonAfterColor'].' !important ; }';
//$style .= '#calendar'.$rand.' table.booked-calendar td:hover {background-color: '.$options[$id.'-hoverDayCellColor'].' !important;}';

        $style .= '#calendar'.$rand.' table.booked-calendar td:hover #date-'.$id.' span {background-color: '.$options[$id.'-hoverDayCellColor'].' !important;}';


        $style .= '#calendar'.$rand.' table.booked-calendar td #date-'.$id.' {background-color: '.$options[$id.'-normalDayCellColor'].' !important; font-family: "'.$normalDayCellFont[0].'" !important; color: '.$options[$id.'-normalDayCellFontColor'].'!important;}';

        $style .= '#calendar'.$rand.' table.booked-calendar td #date-'.$id.'.tooltipster-'.$id.' {background-color: '.$options[$id.'-activeDayCellColor'].' !important; font-family: "'.$activeDayCellFont[0].'" !important; color: '.$options[$id.'-activeDayCellFontColor'].'!important;}';

        $style .= '#calendar'.$rand.' table#calendar-'.$id.' td  { background-color: '.$options[$id.'-calendarColor'].' !important; font-family: "'.$calendarFont[0].'" !important;}';
        $style .= '#calendar'.$rand.' table#calendar-'.$id.' td .booked-appt-list  { background-color: '.$options[$id.'-calendarColor'].' !important; font-family: "'.$calendarFont[0].'" !important; color: '.$options[$id.'-calendarFontColor'].'!important;}';
        $style .= '#calendar'.$rand.' table#calendar-'.$id.' td .booked-appt-list.shown  { background-color: '.$options[$id.'-calendarColor'].' !important; font-family: "'.$calendarFont[0].'" !important; color: '.$options[$id.'-calendarFontColor'].'!important;}';
        $style .= '#calendar'.$rand.' table#calendar-'.$id.' td div.timeslot.bookedClearFix:hover  { background-color: '.$options[$id.'-calendarColor'].' !important; font-family: "'.$calendarFont[0].'" !important; color: '.$options[$id.'-calendarFontColor'].'!important;}';

        $style .= '#title-'.$id.' {background-color: '.$options[$id.'-monthRowColor'].' !important;font-family: '.$monthFont[0].' !important; color: '.$options[$id.'-monthRowFontColor'].'!important;}';
        $style .= '#calendar'.$rand.' .booked-calendar-wrap .booked-appt-list .timeslot .timeslot-time i.booked-icon { color: '.$options[$id.'-calendarFontColor'].'!important;}';

        $style .= 'div.booked-calendar-shortcode-wrap.calendar-wrap-' . $id . ', 
			table#calendar-' . $id . '.booked-calendar tbody tr.entryBlock, 
			table#calendar-' . $id . '.booked-calendar tbody tr.entryBlock div.booked-appt-list.shown, 
			body .booked-modal.calendar-' . $id . ' .bm-window, 
			body .booked-modal.calendar-' . $id . ' .booked-form, 
			body .booked-modal.calendar-' . $id . ' .booked-appointments {'.sprintf(
                'background: %1$s !important;',
                esc_html( $this->settings['calendar_main_color'] )
            ).'}';


        //Calendar Main Font

        $style .= 'div.booked-calendar-shortcode-wrap.calendar-wrap-' . $id . ', 
			table#calendar-' . $id . '.booked-calendar tbody tr.entryBlock, 
			table#calendar-' . $id . '.booked-calendar tbody tr.entryBlock div.booked-appt-list.shown, 
			body .booked-modal.calendar-' . $id . ' .bm-window, 
			body .booked-modal.calendar-' . $id . ' .booked-form, 
			body .booked-modal.calendar-' . $id . ' .booked-appointments {'.sprintf(
                'font-family: %1$s !important;',
                esc_html( $calendar_main_font_array[0] )
            ).'}';

        //Calendar Main Font Bold
        if ( '' !== $calendar_main_font_array[1] ) {
            $style .= 'div.booked-calendar-shortcode-wrap.calendar-wrap-'.$id.', 
				table#calendar-'.$id.'.booked-calendar tbody tr.entryBlock, 
				table#calendar-'.$id.'.booked-calendar tbody tr.entryBlock div.booked-appt-list.shown,
				body .booked-modal.calendar-'.$id.' .bm-window, 
				body .booked-modal.calendar-'.$id.' .booked-form, 
				body .booked-modal.calendar-'.$id.' .booked-appointments {'.sprintf(
                    'font-weight: bold  !important;'
                ).'}';
        }

        //Calendar Main Font italic
        if ( '' !== $calendar_main_font_array[2] ) {
            $style .= 'div.booked-calendar-shortcode-wrap.calendar-wrap-' . $id . ', 
				table#calendar-' . $id . '.booked-calendar tbody tr.entryBlock, 
				table#calendar-' . $id . '.booked-calendar tbody tr.entryBlock div.booked-appt-list.shown, 
				body .booked-modal.calendar-' . $id . ' .bm-window, 
				body .booked-modal.calendar-' . $id . ' .booked-form, 
				body .booked-modal.calendar-' . $id . ' .booked-appointments {'.sprintf(
                    'font-style: italic  !important;'
                ).'}';
        }

        //Calendar Main Font uppercase
        if ( '' !== $calendar_main_font_array[3] ) {
            $style .= 'div.booked-calendar-shortcode-wrap.calendar-wrap-' . $id . ', 
				table#calendar-' . $id . '.booked-calendar tbody tr.entryBlock, 
				table#calendar-' . $id . '.booked-calendar tbody tr.entryBlock div.booked-appt-list.shown,
				body .booked-modal.calendar-' . $id . ' .bm-window, 
				body .booked-modal.calendar-' . $id . ' .booked-form, 
				body .booked-modal.calendar-' . $id . ' .booked-appointments {'.sprintf(
                    'text-transform: uppercase !important;'
                ).'}';
        }

        //Calendar Main Font underline
        if ( '' !== $calendar_main_font_array[4] ) {
            $style .= 'div.booked-calendar-shortcode-wrap.calendar-wrap-' . $id . ', 
				table#calendar-' . $id . '.booked-calendar tbody tr.entryBlock, 
				table#calendar-' . $id . '.booked-calendar tbody tr.entryBlock div.booked-appt-list.shown, 
				body .booked-modal.calendar-' . $id . ' .bm-window, 
				body .booked-modal.calendar-' . $id . ' .booked-form, 
				body .booked-modal.calendar-' . $id . ' .booked-appointments {'.sprintf(
                    'text-decoration: underline !important;'
                ).'}';
        }

        //Calendar Font Color
        $style .= 'div.booked-calendar-shortcode-wrap.calendar-wrap-' . $id . ', 
			table#calendar-' . $id . '.booked-calendar tbody tr.entryBlock, 
			table#calendar-' . $id . '.booked-calendar tbody tr.entryBlock div.booked-appt-list.shown, 
			body .booked-modal.calendar-' . $id . ' .bm-window, 
			body .booked-modal.calendar-' . $id . ' .booked-form, 
			body .booked-modal.calendar-' . $id . ' .booked-appointments {'.sprintf(
                'color: %1$s !important;',
                esc_html( $this->settings['calendar_main_font_color'] )
            ).'}';

        //Month Row Color
        $style .= 'table#calendar-' . $id . '.booked-calendar thead tr.month-' . $id.' {'.sprintf(
                'background: %1$s !important;',
                esc_html( $this->settings['month_row_color'] )
            ).'}';

        //Month Row Font
        $style .= 'table#calendar-' . $id . '.booked-calendar thead tr.month-' . $id . ' th {'. sprintf(
                'font-family: %1$s !important;',
                esc_html( $month_row_font_array[0] )
            ).'}';

        //Month Row Font Bold
        if ( '' !== $month_row_font_array[1] ) {
            $style .= 'table#calendar-' . $id . '.booked-calendar thead tr.month-' . $id . ' th {'.sprintf(
                    'font-weight: bold  !important;'
                ).'}';
        }

        //Month Row Font italic
        if ( '' !== $month_row_font_array[2] ) {
            $style .= 'table#calendar-' . $id . '.booked-calendar thead tr.month-' . $id . ' th {'.sprintf(
                    'font-style: italic  !important;'
                ).'}';
        }

        //Month Row Font uppercase
        if ( '' !== $month_row_font_array[3] ) {
            $style .= 'table#calendar-' . $id . '.booked-calendar thead tr.month-' . $id . ' th {'.sprintf(
                    'text-transform: uppercase !important;'
                ).'}';
        }

        //Month Row Font underline
        if ( '' !== $month_row_font_array[4] ) {
            $style .= 'table#calendar-' . $id . '.booked-calendar thead tr.month-' . $id . ' th {'.sprintf(
                    'text-decoration: underline !important;'
                )."}";
        }

        //Month Row Font Color
        $style .= 'table#calendar-' . $id . '.booked-calendar thead tr.month-' . $id . ' th {'.sprintf(
                'color: %1$s !important;',
                esc_html( $this->settings['month_row_font_color'] )
            )."}";

        //Day Row Color
        $style .= 'table#calendar-' . $id . '.booked-calendar thead tr.days-' . $id." {".sprintf(
                'background: %1$s !important;',
                esc_html( $this->settings['day_row_color'] )
            )."}";

        //Day Row Font

        $style .= 'table#calendar-' . $id . '.booked-calendar thead tr.days-' . $id . ' th {'.sprintf(
                'font-family: %1$s !important;',
                esc_html( $day_row_font_array[0] )
            )." }";

        //Day Row Font Bold
        if ( '' !== $day_row_font_array[1] ) {
            $style .= 'table#calendar-' . $id . '.booked-calendar thead tr.days-' . $id . ' th'." { ".sprintf(
                    'font-weight: bold  !important;'
                )."}";
        }

        //Day Row Font italic
        if ( '' !== $day_row_font_array[2] ) {
            $style .= 'table#calendar-' . $id . '.booked-calendar thead tr.days-' . $id . ' th {'.sprintf(
                    'font-style: italic  !important;'
                )." }";
        }

        //Day Row Font uppercase
        if ( '' !== $day_row_font_array[3] ) {
            $style .= 'table#calendar-' . $id . '.booked-calendar thead tr.days-' . $id . ' th {'.sprintf(
                    'text-transform: uppercase !important;'
                )." }";
        }

        //Day Row Font underline
        if ( '' !== $day_row_font_array[4] ) {
            $style .= 'table#calendar-' . $id . '.booked-calendar thead tr.days-' . $id . ' th {'.sprintf(
                    'text-decoration: underline !important;'
                )."}";
        }

        //Day Row Font Color
        $style .= 'table#calendar-' . $id . '.booked-calendar thead tr.days-' . $id . ' th {'.sprintf(
                'color: %1$s !important;',
                esc_html( $this->settings['day_row_font_color'] )
            )."}";

        //Normal day cell Color
        $style .= 'table#calendar-' . $id . '.booked-calendar tbody td span#date-' . $id . '.date {'.sprintf(
                'background: %1$s !important;',
                esc_html( $this->settings['normal_day_cell_color'] )
            )." }";

        //Normal day cell Font

        $style .= 'table#calendar-' . $id . '.booked-calendar tbody td.prev-date span#date-' . $id . '.date {'.sprintf(
                'font-family: %1$s !important;',
                esc_html( $day_cell_normal_font_array[0] )
            )."}";

        //Normal day cell Font Bold
        if ( '' !== $day_cell_normal_font_array[1] ) {
            $style .= 'table#calendar-' . $id . '.booked-calendar tbody td.prev-date span#date-' . $id . '.date {'.sprintf(
                    'font-weight: bold  !important;'
                )."}";
        }

        //Normal day cell Font italic
        if ( '' !== $day_cell_normal_font_array[2] ) {
            $style .= 'table#calendar-' . $id . '.booked-calendar tbody td.prev-date span#date-' . $id . '.date {'.sprintf(
                    'font-style: italic  !important;'
                )."}";
        }

        //Normal day cell Font uppercase
        if ( '' !== $day_cell_normal_font_array[3] ) {
            $style .= 'table#calendar-' . $id . '.booked-calendar tbody td.prev-date span#date-' . $id . '.date {'.sprintf(
                    'text-transform: uppercase !important;'
                )." }";
        }

        //Normal day cell Font underline
        if ( '' !== $day_cell_normal_font_array[4] ) {
            $style .= 'table#calendar-' . $id . '.booked-calendar tbody td.prev-date span#date-' . $id . '.date {'.sprintf(
                    'text-decoration: underline !important;'
                )."}";
        }

        //Normal day cell Font Color
        $style .= 'table#calendar-' . $id . '.booked-calendar tbody td.prev-date span#date-' . $id . '.date {'.sprintf(
                'color: %1$s !important;',
                esc_html( $this->settings['normal_day_cell_font_color'] )
            )."}";

        //Hover day cell Color
        $style .= 'table#calendar-' . $id . '.booked-calendar tbody td.prev-date span#date-' . $id . '.date:hover { '.sprintf(
                'background: %1$s !important;',
                esc_html( $this->settings['hover_day_cell_color'] )
            )."}";

        //Active day cell Color
        $style .= 'table#calendar-' . $id . '.booked-calendar tbody td span#date-' . $id . '.date.tooltipster-' . $id." {".sprintf(
                'background: %1$s !important;',
                esc_html( $this->settings['active_day_cell_color'] )
            )." }";

        //Active day cell Font

        $style .= 'table#calendar-' . $id . '.booked-calendar tbody td span#date-' . $id . '.date.tooltipster-' . $id.' { '.sprintf(
                'font-family: %1$s !important;',
                esc_html( $day_cell_active_font_array[0] )
            )."}";

        //Active day cell Font Bold
        if ( '' !== $day_cell_active_font_array[1] ) {
            $style .= 'table#calendar-' . $id . '.booked-calendar tbody td span#date-' . $id . '.date.tooltipster-' . $id."{".sprintf(
                    'font-weight: bold  !important;'
                )."}";
        }

        //Active day cell Font italic
        if ( '' !== $day_cell_active_font_array[2] ) {
            $style .= 'table#calendar-' . $id . '.booked-calendar tbody td span#date-' . $id . '.date.tooltipster-' . $id." { ".sprintf(
                    'font-style: italic  !important;'
                )."}";
        }

        //Active day cell Font uppercase
        if ( '' !== $day_cell_active_font_array[3] ) {
            $style .= 'table#calendar-' . $id . '.booked-calendar tbody td span#date-' . $id . '.date.tooltipster-' . $id." { ".sprintf(
                    'text-transform: uppercase !important;'
                )." } ";
        }

        //Active day cell Font underline
        if ( '' !== $day_cell_active_font_array[4] ) {
            $style .= 'table#calendar-' . $id . '.booked-calendar tbody td span#date-' . $id . '.date.tooltipster-' . $id." {".sprintf(
                    'text-decoration: underline !important;'
                )." }";
        }

        //Active day cell Font Color
        $style .= '#calendar-' . $id . '.booked-calendar tbody td span#date-' . $id . '.date.tooltipster-' . $id." { ".sprintf(
                'color: %1$s !important;',
                esc_html( $this->settings['active_day_cell_font_color'] )
            )." }";

        //Button before Color
        $style .= 'button#book-button-' . $id . '.new-appt.button, #submit-request-appointment-' . $id.' {'.sprintf(
                'background: %1$s !important;',
                esc_html( $this->settings['button_before_color'] )
            )."}";

        //Button after Color
        $style .= 'button#book-button-' . $id . '.new-appt.button:hover, #submit-request-appointment-' . $id . ':hover {'.sprintf(
                'background: %1$s !important;',
                esc_html( $this->settings['button_after_color'] )
            )."}";

        //Button Font

        $style .= 'button#book-button-' . $id . '.new-appt.button, #submit-request-appointment-' . $id." {".sprintf(
                'font-family: %1$s !important;',
                esc_html( $button_font_array[0] )
            )." }";

        //Button Font Bold
        if ( '' !== $button_font_array[1] ) {
            $style .= 'button#book-button-' . $id . '.new-appt.button, #submit-request-appointment-' . $id." {".sprintf(
                    'font-weight: bold  !important;'
                )."}";
        }

        //Button Font italic
        if ( '' !== $button_font_array[2] ) {
            $style .= 'button#book-button-' . $id . '.new-appt.button, #submit-request-appointment-' . $id." {".sprintf(
                    'font-style: italic  !important;'
                )."}";
        }

        //Button Font uppercase
        if ( '' !== $button_font_array[3] ) {
            $style .= 'button#book-button-' . $id . '.new-appt.button, #submit-request-appointment-' . $id." {".sprintf(
                    'text-transform: uppercase !important;'
                )."}";
        }

        //Active day cell Font underline
        if ( '' !== $button_font_array[4] ) {
            $style .= 'button#book-button-' . $id . '.new-appt.button, #submit-request-appointment-' . $id."{".sprintf(
                    'text-decoration: underline !important;'
                )."}";
        }

        //Button Font Color
        $style .= 'button#book-button-' . $id . '.new-appt.button, #submit-request-appointment-' . $id." {".sprintf(
                'color: %1$s !important;',
                esc_html( $this->settings['button_font'] )
            )."}";

        $content = " <div id='calendar".$id."'>
          ".$output."</div>";

        $this->props['calendar_code_id'] = $id;
        $this->props['calendar_code'] = $content;
    }

    public function render($atts, $content = null, $render_slug)
    {

        $this->default_values = array(
            'calendar_selector'          => 0,
            'calendar_main_color'        => '#ffffff',
            'calendar_main_font'         => 'Roboto|||||',
            'calendar_main_font_color'   => '#000000',
            'month_row_color'            => '#C4F2D4',
            'month_row_font'             => 'Roboto|||||',
            'month_row_font_color'       => '#000000',
            'day_row_color'              => '#c4f2d4',
            'day_row_font'               => 'Roboto|||||',
            'day_row_font_color'         => '#000000',
            'normal_day_cell_color'      => '#F5F5F5',
            'normal_day_cell_font'       => 'Roboto|||||',
            'normal_day_cell_font_color' => '#000000',
            'hover_day_cell_color'       => '#000000',
            'active_day_cell_color'      => '#ffffff',
            'active_day_cell_font'       => 'Roboto|||||',
            'active_day_cell_font_color' => '#000000',
            'button_before_color'        => '#CAEBD5',
            'button_after_color'         => '#C4F2D4',
            'button_font'                => 'Roboto|||||',
            'button_font_color'          => '#000000',
            'admin_label'                => 'Agent-Calendar',
            'calendar_code'              => '',
        );


        $calendars = get_terms( 'booked_custom_calendars', array(
            'orderby'    => 'name',
            'order'      => 'ASC',
            'hide_empty' => false
        ) );

        $this->settings['calendar_selector']          = isset( $atts['calendar_selector'] ) ? $atts['calendar_selector'] : $this->default_values['calendar_selector'];
        $this->settings['calendar_main_color']        = isset( $atts['calendar_main_color'] ) ? $atts['calendar_main_color'] : $this->default_values['calendar_main_color'];
        $this->settings['calendar_main_font']         = isset( $atts['calendar_main_font'] ) ? $atts['calendar_main_font'] : $this->default_values['calendar_main_font'];
        $this->settings['calendar_main_font_color']   = isset( $atts['calendar_main_font_color'] ) ? $atts['calendar_main_font_color'] : $this->default_values['calendar_main_font_color'];
        $this->settings['month_row_color']            = isset( $atts['month_row_color'] ) ? $atts['month_row_color'] : $this->default_values['month_row_color'];
        $this->settings['month_row_font']             = isset( $atts['month_row_font'] ) ? $atts['month_row_font'] : $this->default_values['month_row_font'];
        $this->settings['month_row_font_color']       = isset( $atts['month_row_font_color'] ) ? $atts['month_row_font_color'] : $this->default_values['month_row_font_color'];
        $this->settings['day_row_color']              = isset( $atts['day_row_color'] ) ? $atts['day_row_color'] : $this->default_values['day_row_color'];
        $this->settings['day_row_font']               = isset( $atts['day_row_font'] ) ? $atts['day_row_font'] : $this->default_values['day_row_font'];
        $this->settings['day_row_font_color']         = isset( $atts['day_row_font_color'] ) ? $atts['day_row_font_color'] : $this->default_values['day_row_font_color'];
        $this->settings['normal_day_cell_color']      = isset( $atts['normal_day_cell_color'] ) ? $atts['normal_day_cell_color'] : $this->default_values['normal_day_cell_color'];
        $this->settings['normal_day_cell_font']       = isset( $atts['normal_day_cell_font'] ) ? $atts['normal_day_cell_font'] : $this->default_values['normal_day_cell_font'];
        $this->settings['normal_day_cell_font_color'] = isset( $atts['normal_day_cell_font_color'] ) ? $atts['normal_day_cell_font_color'] : $this->default_values['normal_day_cell_font_color'];
        $this->settings['hover_day_cell_color']       = isset( $atts['hover_day_cell_color'] ) ? $atts['hover_day_cell_color'] : $this->default_values['hover_day_cell_color'];
        $this->settings['active_day_cell_color']      = isset( $atts['active_day_cell_color'] ) ? $atts['active_day_cell_color'] : $this->default_values['active_day_cell_color'];
        $this->settings['active_day_cell_font']       = isset( $atts['active_day_cell_font'] ) ? $atts['active_day_cell_font'] : $this->default_values['active_day_cell_font'];
        $this->settings['active_day_cell_font_color'] = isset( $atts['active_day_cell_font_color'] ) ? $atts['active_day_cell_font_color'] : $this->default_values['active_day_cell_font_color'];
        $this->settings['button_before_color']        = isset( $atts['button_before_color'] ) ? $atts['button_before_color'] : $this->default_values['button_before_color'];
        $this->settings['button_after_color']         = isset( $atts['button_after_color'] ) ? $atts['button_after_color'] : $this->default_values['button_after_color'];
        $this->settings['button_font']                = isset( $atts['button_font'] ) ? $atts['button_font'] : $this->default_values['button_font'];
        $this->settings['button_font_color']          = isset( $atts['button_font_color'] ) ? $atts['button_font_color'] : $this->default_values['button_font_color'];
        $this->settings['admin_label']                = isset( $atts['admin_label'] ) ? $atts['admin_label'] : $this->default_values['admin_label'];
        $this->settings['module_id']                  = $this->shortcode_atts['module_id'];
        $this->settings['module_class']               = $this->shortcode_atts['module_class'];


        $nameSelected = $this->settings['calendar_selector'];
        $id           = 0;

        foreach ( $calendars as $cal ) {
            if ( $cal->name == $nameSelected ) {
                $id = $cal->term_id;
            }
        }

        $local_time = current_time( 'timestamp' );
        $year       = date_i18n( 'Y', $local_time );
        $month      = date_i18n( 'm', $local_time );

        // $module_class = ET_Builder_Element::add_module_order_class( $this->settings['module_class'], $function_name );

        $calendar_main_font_array = explode( '|', $this->settings['calendar_main_font'] );
        $calendar_main_font_url   = str_replace( ' ', '+', $calendar_main_font_array[0] );

        $month_row_font_array = explode( '|', $this->settings['month_row_font'] );
        $month_row_font_url   = str_replace( ' ', '+', $month_row_font_array[0] );

        $day_row_font_array = explode( '|', $this->settings['day_row_font'] );
        $day_row_font_url   = str_replace( ' ', '+', $day_row_font_array[0] );

        $day_cell_normal_font_array = explode( '|', $this->settings['normal_day_cell_font'] );
        $day_cell_normal_font_url   = str_replace( ' ', '+', $day_cell_normal_font_array[0] );

        $day_cell_active_font_array = explode( '|', $this->settings['active_day_cell_font'] );
        $day_cell_active_font_url   = str_replace( ' ', '+', $day_cell_active_font_array[0] );

        $button_font_array = explode( '|', $this->settings['button_font'] );
        $button_font_url   = str_replace( ' ', '+', $button_font_array[0] );

        //Calendar Main Color



        $options = array();

        $rand = rand(0,999);

        $options[$id.'-calendarColor'] = isset( $atts['calendar_main_color'] ) ? $atts['calendar_main_color'] : $this->default_values['calendar_main_color'];
        $options[$id.'-monthRowColor'] = isset( $atts['month_row_color'] ) ? $atts['month_row_color'] : $this->default_values['month_row_color'];
        $options[$id.'-dayRowColor'] = isset( $atts['day_row_color'] ) ? $atts['day_row_color'] : $this->default_values['day_row_color'];
        $options[$id.'-buttonBeforeColor'] = isset( $atts['button_before_color'] ) ? $atts['button_before_color'] : $this->default_values['button_before_color'];
        $options[$id.'-buttonAfterColor'] = isset( $atts['button_after_color'] ) ? $atts['button_after_color'] : $this->default_values['button_after_color'];
        $options[$id.'-activeDayCellColor'] = isset( $atts['active_day_cell_color'] ) ? $atts['active_day_cell_color'] : $this->default_values['active_day_cell_color'];
        $options[$id.'-normalDayCellColor'] = isset( $atts['normal_day_cell_color'] ) ? $atts['normal_day_cell_color'] : $this->default_values['normal_day_cell_color'];
        $options[$id.'-calendarFontColor'] = isset( $atts['calendar_main_font_color'] ) ? $atts['calendar_main_font_color'] : $this->default_values['calendar_main_font_color'];
        $options[$id.'-monthRowFont'] = isset( $atts['month_row_font'] ) ? $atts['month_row_font'] : $this->default_values['month_row_font'];
        $options[$id.'-monthRowFontColor'] = isset( $atts['month_row_font_color'] ) ? $atts['month_row_font_color'] : $this->default_values['month_row_font_color'];
        $options[$id.'-dayRowFont'] = isset( $atts['day_row_font'] ) ? $atts['day_row_font'] : $this->default_values['day_row_font'];
        $options[$id.'-dayRowFontColor'] = isset( $atts['day_row_font_color'] ) ? $atts['day_row_font_color'] : $this->default_values['day_row_font_color'];
        $options[$id.'-normalDayCellFont'] = isset( $atts['normal_day_cell_font'] ) ? $atts['normal_day_cell_font'] : $this->default_values['normal_day_cell_font'];
        $options[$id.'-normalDayCellFontColor'] = isset( $atts['normal_day_cell_font_color'] ) ? $atts['normal_day_cell_font_color'] : $this->default_values['normal_day_cell_font_color'];
        $options[$id.'-activeDayCellFont'] = isset( $atts['active_day_cell_font'] ) ? $atts['active_day_cell_font'] : $this->default_values['active_day_cell_font'];
        $options[$id.'-activeDayCellFontColor'] = isset( $atts['active_day_cell_font_color'] ) ? $atts['active_day_cell_font_color'] : $this->default_values['active_day_cell_font_color'];
        $options[$id.'-buttonFont'] = isset( $atts['button_font'] ) ? $atts['button_font'] : $this->default_values['button_font'];
        $options[$id.'-buttonFontColor'] = isset( $atts['button_font_color'] ) ? $atts['button_font_color'] : $this->default_values['button_font_color'];
        $options[$id.'-adminLabel'] = isset( $atts['admin_label'] ) ? $atts['admin_label'] : $this->default_values['admin_label'];
        $options[$id.'-hoverDayCellColor'] = isset( $atts['hover_day_cell_color'] ) ? $atts['hover_day_cell_color'] : $this->default_values['hover_day_cell_color'];


        $output = booked_fe_calendar_divi( $year, $month, $id, false, $options, true);
        $style = " ";


        $calendarFontUrl = str_replace( ' ', '+', $options[$id.'-calendarFont']);
        $monthFontUrl = str_replace( ' ', '+', $options[$id.'-monthRowFont']);
        $dayFontUrl = str_replace( ' ', '+', $options[$id.'-dayRowFont']);
        $normalDayCellFontUrl = str_replace( ' ', '+', $options[$id.'-normalDayCellFont']);
        $activeDayCellFontUrl = str_replace( ' ', '+', $options[$id.'-activeDayCellFont']);
        $buttonFontUrl = str_replace( ' ', '+', $options[$id.'-buttonFont']);

        $calendarFont = explode('|', $options[$id.'-calendarFont']);
        $monthFont = explode( '|', $options[$id.'-monthRowFont']);
        $dayFont = explode( '|', $options[$id.'-dayRowFont']);
        $normalDayCellFont = explode( '|', $options[$id.'-normalDayCellFont']);
        $activeDayCellFont = explode( '|', $options[$id.'-activeDayCellFont']);
        $buttonFont = explode( '|', $options[$id.'-buttonFont']);


//echo '#test:before {content: "'.$options[$id.'-normalDayCellFontColor'].'";}';
        $style .= '#calendar'.$rand.' table.booked-calendar thead th .page-right, #calendar'.$rand.' table.booked-calendar thead th .page-left { color: '.$options[$id.'-monthRowFontColor'].'!important;}';
        $style .= '#calendar'.$rand.' .booked-form .booked-appointments{ background-color: '.$options[$id.'-calendarColor'].' !important; font-family: "'.$calendarFont[0].'" !important; color: '.$options[$id.'-calendarFontColor'].'!important;}';
        $style .= '#calendar'.$rand.' .booked-modal .bm-window .booked-scrollable  { background-color: '.$options[$id.'-calendarColor'].' !important; font-family: "'.$calendarFont[0].'" !important; color: '.$options[$id.'-calendarFontColor'].'!important;}';
        $style .= '#calendar'.$rand.' .booked-calendar-wrap .booked-appt-list h2 {font-family: "'.$calendarFont[0].'" !important; color: '.$options[$id.'-calendarFontColor'].'!important;}';
        $style .= '#calendar'.$rand.' .booked-calendar-wrap .booked-appt-list .timeslot .timeslot-time, #calendar'.$rand.' .booked-calendar-wrap .booked-appt-list .timeslot .spots-available {font-family: "'.$calendarFont[0].'" !important; color: '.$options[$id.'-calendarFontColor'].'!important;}';
        $style .= '#calendar'.$rand.' table.booked-calendar td.today .date span {border: 2px solid '.$options[$id.'-hoverDayCellColor'].';color:#000 !important;}';

        /*
        $style .= '#calendar'.$rand.' table.booked-calendar .monthRow {border-color: '.$options[$id.'-m'].' !important; background-color: '.$options[$id.'-calendarColor'].' !important; font-family: '.$options[$id.'-calendarColor'].' !important; color:  '.$options[$id.'-calendarColor'].' !important;}';
        */
        $style .= '#calendar'.$rand.' table.booked-calendar tr.month-'.$id.' th{ border-color: '.$options[$id.'-monthRowColor'].' !important;background-color: '.$options[$id.'-monthRowColor'].' !important; font-family: '.$monthFont[0].' !important; color: '.$options[$id.'-monthRowFontColor'].'!important;}';

        $style .= '#calendar'.$rand.' table.booked-calendar tr.days-'.$id.' th{ border-color: '.$options[$id.'-dayRowColor'].' !important;background-color: '.$options[$id.'-dayRowColor'].' !important; font-family: "'.$dayFont[0].'" !important;font-family: "'.$dayFont[0].'" !important; color: '.$options[$id.'-dayRowFontColor'].'!important;}';
        $style .= '#calendar'.$rand.' table.booked-calendar .booked-appt-list .timeslot .timeslot-people button#book-button-'.$id.'{ border-color: '.$options[$id.'-buttonBeforeColor'].' !important ;  background-color: '.$options[$id.'-buttonBeforeColor'].' !important ; font-family: "'.$buttonFont[0].'" !important; color: '.$options[$id.'-buttonFontColor'].'!important;}';
        $style .= '#calendar'.$rand.' table.booked-calendar .booked-appt-list .timeslot .timeslot-people button#book-button-'.$id.':hover{ border-color: '.$options[$id.'-buttonAfterColor'].' !important ;  background-color: '.$options[$id.'-buttonAfterColor'].' !important ;}';


        $style .= '#calendar'.$rand.' .booked-modal input[type=submit]#submit-request-appointment-'.$id.'{ border-color: '.$options[$id.'-buttonBeforeColor'].' !important ;  background-color: '.$options[$id.'-buttonBeforeColor'].' !important ; font-family: "'.$buttonFont[0].'" !important; color: '.$options[$id.'-buttonFontColor'].'!important;}';
        $style .= '#calendar'.$rand.' .booked-modal input[type=submit]#submit-request-appointment-'.$id.':hover{ border-color: '.$options[$id.'-buttonAfterColor'].' !important ;  background-color: '.$options[$id.'-buttonAfterColor'].' !important ; }';
//$style .= '#calendar'.$rand.' table.booked-calendar td:hover {background-color: '.$options[$id.'-hoverDayCellColor'].' !important;}';

        $style .= '#calendar'.$rand.' table.booked-calendar td:hover #date-'.$id.' span {background-color: '.$options[$id.'-hoverDayCellColor'].' !important;}';


        $style .= '#calendar'.$rand.' table.booked-calendar td #date-'.$id.' {background-color: '.$options[$id.'-normalDayCellColor'].' !important; font-family: "'.$normalDayCellFont[0].'" !important; color: '.$options[$id.'-normalDayCellFontColor'].'!important;}';

        $style .= '#calendar'.$rand.' table.booked-calendar td #date-'.$id.'.tooltipster-'.$id.' {background-color: '.$options[$id.'-activeDayCellColor'].' !important; font-family: "'.$activeDayCellFont[0].'" !important; color: '.$options[$id.'-activeDayCellFontColor'].'!important;}';

        $style .= '#calendar'.$rand.' table#calendar-'.$id.' td  { background-color: '.$options[$id.'-calendarColor'].' !important; font-family: "'.$calendarFont[0].'" !important;}';
        $style .= '#calendar'.$rand.' table#calendar-'.$id.' td .booked-appt-list  { background-color: '.$options[$id.'-calendarColor'].' !important; font-family: "'.$calendarFont[0].'" !important; color: '.$options[$id.'-calendarFontColor'].'!important;}';
        $style .= '#calendar'.$rand.' table#calendar-'.$id.' td .booked-appt-list.shown  { background-color: '.$options[$id.'-calendarColor'].' !important; font-family: "'.$calendarFont[0].'" !important; color: '.$options[$id.'-calendarFontColor'].'!important;}';
        $style .= '#calendar'.$rand.' table#calendar-'.$id.' td div.timeslot.bookedClearFix:hover  { background-color: '.$options[$id.'-calendarColor'].' !important; font-family: "'.$calendarFont[0].'" !important; color: '.$options[$id.'-calendarFontColor'].'!important;}';

        $style .= '#title-'.$id.' {background-color: '.$options[$id.'-monthRowColor'].' !important;font-family: '.$monthFont[0].' !important; color: '.$options[$id.'-monthRowFontColor'].'!important;}';
        $style .= '#calendar'.$rand.' .booked-calendar-wrap .booked-appt-list .timeslot .timeslot-time i.booked-icon { color: '.$options[$id.'-calendarFontColor'].'!important;}';

        $style .= 'div.booked-calendar-shortcode-wrap.calendar-wrap-' . $id . ', 
			table#calendar-' . $id . '.booked-calendar tbody tr.entryBlock, 
			table#calendar-' . $id . '.booked-calendar tbody tr.entryBlock div.booked-appt-list.shown, 
			body .booked-modal.calendar-' . $id . ' .bm-window, 
			body .booked-modal.calendar-' . $id . ' .booked-form, 
			body .booked-modal.calendar-' . $id . ' .booked-appointments {'.sprintf(
                'background: %1$s !important;',
                esc_html( $this->settings['calendar_main_color'] )
            ).'}';


        //Calendar Main Font

        $style .= 'div.booked-calendar-shortcode-wrap.calendar-wrap-' . $id . ', 
			table#calendar-' . $id . '.booked-calendar tbody tr.entryBlock, 
			table#calendar-' . $id . '.booked-calendar tbody tr.entryBlock div.booked-appt-list.shown, 
			body .booked-modal.calendar-' . $id . ' .bm-window, 
			body .booked-modal.calendar-' . $id . ' .booked-form, 
			body .booked-modal.calendar-' . $id . ' .booked-appointments {'.sprintf(
                'font-family: %1$s !important;',
                esc_html( $calendar_main_font_array[0] )
            ).'}';

        //Calendar Main Font Bold
        if ( '' !== $calendar_main_font_array[1] ) {
            $style .= 'div.booked-calendar-shortcode-wrap.calendar-wrap-'.$id.', 
				table#calendar-'.$id.'.booked-calendar tbody tr.entryBlock, 
				table#calendar-'.$id.'.booked-calendar tbody tr.entryBlock div.booked-appt-list.shown,
				body .booked-modal.calendar-'.$id.' .bm-window, 
				body .booked-modal.calendar-'.$id.' .booked-form, 
				body .booked-modal.calendar-'.$id.' .booked-appointments {'.sprintf(
                    'font-weight: bold  !important;'
                ).'}';
        }

        //Calendar Main Font italic
        if ( '' !== $calendar_main_font_array[2] ) {
            $style .= 'div.booked-calendar-shortcode-wrap.calendar-wrap-' . $id . ', 
				table#calendar-' . $id . '.booked-calendar tbody tr.entryBlock, 
				table#calendar-' . $id . '.booked-calendar tbody tr.entryBlock div.booked-appt-list.shown, 
				body .booked-modal.calendar-' . $id . ' .bm-window, 
				body .booked-modal.calendar-' . $id . ' .booked-form, 
				body .booked-modal.calendar-' . $id . ' .booked-appointments {'.sprintf(
                    'font-style: italic  !important;'
                ).'}';
        }

        //Calendar Main Font uppercase
        if ( '' !== $calendar_main_font_array[3] ) {
            $style .= 'div.booked-calendar-shortcode-wrap.calendar-wrap-' . $id . ', 
				table#calendar-' . $id . '.booked-calendar tbody tr.entryBlock, 
				table#calendar-' . $id . '.booked-calendar tbody tr.entryBlock div.booked-appt-list.shown,
				body .booked-modal.calendar-' . $id . ' .bm-window, 
				body .booked-modal.calendar-' . $id . ' .booked-form, 
				body .booked-modal.calendar-' . $id . ' .booked-appointments {'.sprintf(
                    'text-transform: uppercase !important;'
                ).'}';
        }

        //Calendar Main Font underline
        if ( '' !== $calendar_main_font_array[4] ) {
            $style .= 'div.booked-calendar-shortcode-wrap.calendar-wrap-' . $id . ', 
				table#calendar-' . $id . '.booked-calendar tbody tr.entryBlock, 
				table#calendar-' . $id . '.booked-calendar tbody tr.entryBlock div.booked-appt-list.shown, 
				body .booked-modal.calendar-' . $id . ' .bm-window, 
				body .booked-modal.calendar-' . $id . ' .booked-form, 
				body .booked-modal.calendar-' . $id . ' .booked-appointments {'.sprintf(
                    'text-decoration: underline !important;'
                ).'}';
        }

        //Calendar Font Color
        $style .= 'div.booked-calendar-shortcode-wrap.calendar-wrap-' . $id . ', 
			table#calendar-' . $id . '.booked-calendar tbody tr.entryBlock, 
			table#calendar-' . $id . '.booked-calendar tbody tr.entryBlock div.booked-appt-list.shown, 
			body .booked-modal.calendar-' . $id . ' .bm-window, 
			body .booked-modal.calendar-' . $id . ' .booked-form, 
			body .booked-modal.calendar-' . $id . ' .booked-appointments {'.sprintf(
                'color: %1$s !important;',
                esc_html( $this->settings['calendar_main_font_color'] )
            ).'}';

        //Month Row Color
        $style .= 'table#calendar-' . $id . '.booked-calendar thead tr.month-' . $id.' {'.sprintf(
                'background: %1$s !important;',
                esc_html( $this->settings['month_row_color'] )
            ).'}';

        //Month Row Font
        $style .= 'table#calendar-' . $id . '.booked-calendar thead tr.month-' . $id . ' th {'. sprintf(
                'font-family: %1$s !important;',
                esc_html( $month_row_font_array[0] )
            ).'}';

        //Month Row Font Bold
        if ( '' !== $month_row_font_array[1] ) {
            $style .= 'table#calendar-' . $id . '.booked-calendar thead tr.month-' . $id . ' th {'.sprintf(
                    'font-weight: bold  !important;'
                ).'}';
        }

        //Month Row Font italic
        if ( '' !== $month_row_font_array[2] ) {
            $style .= 'table#calendar-' . $id . '.booked-calendar thead tr.month-' . $id . ' th {'.sprintf(
                    'font-style: italic  !important;'
                ).'}';
        }

        //Month Row Font uppercase
        if ( '' !== $month_row_font_array[3] ) {
            $style .= 'table#calendar-' . $id . '.booked-calendar thead tr.month-' . $id . ' th {'.sprintf(
                    'text-transform: uppercase !important;'
                ).'}';
        }

        //Month Row Font underline
        if ( '' !== $month_row_font_array[4] ) {
            $style .= 'table#calendar-' . $id . '.booked-calendar thead tr.month-' . $id . ' th {'.sprintf(
                    'text-decoration: underline !important;'
                )."}";
        }

        //Month Row Font Color
        $style .= 'table#calendar-' . $id . '.booked-calendar thead tr.month-' . $id . ' th {'.sprintf(
                'color: %1$s !important;',
                esc_html( $this->settings['month_row_font_color'] )
            )."}";

        //Day Row Color
        $style .= 'table#calendar-' . $id . '.booked-calendar thead tr.days-' . $id." {".sprintf(
                'background: %1$s !important;',
                esc_html( $this->settings['day_row_color'] )
            )."}";

        //Day Row Font

        $style .= 'table#calendar-' . $id . '.booked-calendar thead tr.days-' . $id . ' th {'.sprintf(
                'font-family: %1$s !important;',
                esc_html( $day_row_font_array[0] )
            )." }";

        //Day Row Font Bold
        if ( '' !== $day_row_font_array[1] ) {
            $style .= 'table#calendar-' . $id . '.booked-calendar thead tr.days-' . $id . ' th'." { ".sprintf(
                    'font-weight: bold  !important;'
                )."}";
        }

        //Day Row Font italic
        if ( '' !== $day_row_font_array[2] ) {
            $style .= 'table#calendar-' . $id . '.booked-calendar thead tr.days-' . $id . ' th {'.sprintf(
                    'font-style: italic  !important;'
                )." }";
        }

        //Day Row Font uppercase
        if ( '' !== $day_row_font_array[3] ) {
            $style .= 'table#calendar-' . $id . '.booked-calendar thead tr.days-' . $id . ' th {'.sprintf(
                    'text-transform: uppercase !important;'
                )." }";
        }

        //Day Row Font underline
        if ( '' !== $day_row_font_array[4] ) {
            $style .= 'table#calendar-' . $id . '.booked-calendar thead tr.days-' . $id . ' th {'.sprintf(
                    'text-decoration: underline !important;'
                )."}";
        }

        //Day Row Font Color
        $style .= 'table#calendar-' . $id . '.booked-calendar thead tr.days-' . $id . ' th {'.sprintf(
                'color: %1$s !important;',
                esc_html( $this->settings['day_row_font_color'] )
            )."}";

        //Normal day cell Color
        $style .= 'table#calendar-' . $id . '.booked-calendar tbody td span#date-' . $id . '.date {'.sprintf(
                'background: %1$s !important;',
                esc_html( $this->settings['normal_day_cell_color'] )
            )." }";

        //Normal day cell Font

        $style .= 'table#calendar-' . $id . '.booked-calendar tbody td.prev-date span#date-' . $id . '.date {'.sprintf(
                'font-family: %1$s !important;',
                esc_html( $day_cell_normal_font_array[0] )
            )."}";

        //Normal day cell Font Bold
        if ( '' !== $day_cell_normal_font_array[1] ) {
            $style .= 'table#calendar-' . $id . '.booked-calendar tbody td.prev-date span#date-' . $id . '.date {'.sprintf(
                    'font-weight: bold  !important;'
                )."}";
        }

        //Normal day cell Font italic
        if ( '' !== $day_cell_normal_font_array[2] ) {
            $style .= 'table#calendar-' . $id . '.booked-calendar tbody td.prev-date span#date-' . $id . '.date {'.sprintf(
                    'font-style: italic  !important;'
                )."}";
        }

        //Normal day cell Font uppercase
        if ( '' !== $day_cell_normal_font_array[3] ) {
            $style .= 'table#calendar-' . $id . '.booked-calendar tbody td.prev-date span#date-' . $id . '.date {'.sprintf(
                    'text-transform: uppercase !important;'
                )." }";
        }

        //Normal day cell Font underline
        if ( '' !== $day_cell_normal_font_array[4] ) {
            $style .= 'table#calendar-' . $id . '.booked-calendar tbody td.prev-date span#date-' . $id . '.date {'.sprintf(
                    'text-decoration: underline !important;'
                )."}";
        }

        //Normal day cell Font Color
        $style .= 'table#calendar-' . $id . '.booked-calendar tbody td.prev-date span#date-' . $id . '.date {'.sprintf(
                'color: %1$s !important;',
                esc_html( $this->settings['normal_day_cell_font_color'] )
            )."}";

        //Hover day cell Color
        $style .= 'table#calendar-' . $id . '.booked-calendar tbody td.prev-date span#date-' . $id . '.date:hover { '.sprintf(
                'background: %1$s !important;',
                esc_html( $this->settings['hover_day_cell_color'] )
            )."}";

        //Active day cell Color
        $style .= 'table#calendar-' . $id . '.booked-calendar tbody td span#date-' . $id . '.date.tooltipster-' . $id." {".sprintf(
                'background: %1$s !important;',
                esc_html( $this->settings['active_day_cell_color'] )
            )." }";

        //Active day cell Font

        $style .= 'table#calendar-' . $id . '.booked-calendar tbody td span#date-' . $id . '.date.tooltipster-' . $id.' { '.sprintf(
                'font-family: %1$s !important;',
                esc_html( $day_cell_active_font_array[0] )
            )."}";

        //Active day cell Font Bold
        if ( '' !== $day_cell_active_font_array[1] ) {
            $style .= 'table#calendar-' . $id . '.booked-calendar tbody td span#date-' . $id . '.date.tooltipster-' . $id."{".sprintf(
                    'font-weight: bold  !important;'
                )."}";
        }

        //Active day cell Font italic
        if ( '' !== $day_cell_active_font_array[2] ) {
            $style .= 'table#calendar-' . $id . '.booked-calendar tbody td span#date-' . $id . '.date.tooltipster-' . $id." { ".sprintf(
                    'font-style: italic  !important;'
                )."}";
        }

        //Active day cell Font uppercase
        if ( '' !== $day_cell_active_font_array[3] ) {
            $style .= 'table#calendar-' . $id . '.booked-calendar tbody td span#date-' . $id . '.date.tooltipster-' . $id." { ".sprintf(
                    'text-transform: uppercase !important;'
                )." } ";
        }

        //Active day cell Font underline
        if ( '' !== $day_cell_active_font_array[4] ) {
            $style .= 'table#calendar-' . $id . '.booked-calendar tbody td span#date-' . $id . '.date.tooltipster-' . $id." {".sprintf(
                    'text-decoration: underline !important;'
                )." }";
        }

        //Active day cell Font Color
        $style .= '#calendar-' . $id . '.booked-calendar tbody td span#date-' . $id . '.date.tooltipster-' . $id." { ".sprintf(
                'color: %1$s !important;',
                esc_html( $this->settings['active_day_cell_font_color'] )
            )." }";

        //Button before Color
        $style .= 'button#book-button-' . $id . '.new-appt.button, #submit-request-appointment-' . $id.' {'.sprintf(
                'background: %1$s !important;',
                esc_html( $this->settings['button_before_color'] )
            )."}";

        //Button after Color
        $style .= 'button#book-button-' . $id . '.new-appt.button:hover, #submit-request-appointment-' . $id . ':hover {'.sprintf(
                'background: %1$s !important;',
                esc_html( $this->settings['button_after_color'] )
            )."}";

        //Button Font

        $style .= 'button#book-button-' . $id . '.new-appt.button, #submit-request-appointment-' . $id." {".sprintf(
                'font-family: %1$s !important;',
                esc_html( $button_font_array[0] )
            )." }";

        //Button Font Bold
        if ( '' !== $button_font_array[1] ) {
            $style .= 'button#book-button-' . $id . '.new-appt.button, #submit-request-appointment-' . $id." {".sprintf(
                    'font-weight: bold  !important;'
                )."}";
        }

        //Button Font italic
        if ( '' !== $button_font_array[2] ) {
            $style .= 'button#book-button-' . $id . '.new-appt.button, #submit-request-appointment-' . $id." {".sprintf(
                    'font-style: italic  !important;'
                )."}";
        }

        //Button Font uppercase
        if ( '' !== $button_font_array[3] ) {
            $style .= 'button#book-button-' . $id . '.new-appt.button, #submit-request-appointment-' . $id." {".sprintf(
                    'text-transform: uppercase !important;'
                )."}";
        }

        //Active day cell Font underline
        if ( '' !== $button_font_array[4] ) {
            $style .= 'button#book-button-' . $id . '.new-appt.button, #submit-request-appointment-' . $id."{".sprintf(
                    'text-decoration: underline !important;'
                )."}";
        }

        //Button Font Color
        $style .= 'button#book-button-' . $id . '.new-appt.button, #submit-request-appointment-' . $id." {".sprintf(
                'color: %1$s !important;',
                esc_html( $this->settings['button_font'] )
            )."}";

        $content = "
        <style>@import url(https://fonts.googleapis.com/css?family=".$calendar_main_font_url ."</style>
        <style>@import url(https://fonts.googleapis.com/css?family=".$month_row_font_url ."</style>
        <style>@import url(https://fonts.googleapis.com/css?family=".$day_row_font_url ."</style>
        <style>@import url(https://fonts.googleapis.com/css?family=".$day_cell_normal_font_url ."</style>
        <style>@import url(https://fonts.googleapis.com/css?family=".$day_cell_active_font_url ."</style>
        <style>@import url(https://fonts.googleapis.com/css?family=".$button_font_url ."</style>
        <style>
        ".$style."
</style>
        <div id='calendar".$rand."'>
          ".$output."</div>";


        return $this->_render_module_wrapper($output, $render_slug);
    }


    public function shortcode_callback( $atts, $content = null, $function_name ) {


        $this->default_values = array(
            'calendar_selector'          => 0,
            'calendar_main_color'        => '#ffffff',
            'calendar_main_font'         => 'Roboto|||||',
            'calendar_main_font_color'   => '#000000',
            'month_row_color'            => '#C4F2D4',
            'month_row_font'             => 'Roboto|||||',
            'month_row_font_color'       => '#000000',
            'day_row_color'              => '#c4f2d4',
            'day_row_font'               => 'Roboto|||||',
            'day_row_font_color'         => '#000000',
            'normal_day_cell_color'      => '#F5F5F5',
            'normal_day_cell_font'       => 'Roboto|||||',
            'normal_day_cell_font_color' => '#000000',
            'hover_day_cell_color'       => '#000000',
            'active_day_cell_color'      => '#ffffff',
            'active_day_cell_font'       => 'Roboto|||||',
            'active_day_cell_font_color' => '#000000',
            'button_before_color'        => '#CAEBD5',
            'button_after_color'         => '#C4F2D4',
            'button_font'                => 'Roboto|||||',
            'button_font_color'          => '#000000',
            'admin_label'                => 'Agent-Calendar',
            'calendar_code'              => "włat?"
        );

        $calendars = get_terms( 'booked_custom_calendars', array(
            'orderby'    => 'name',
            'order'      => 'ASC',
            'hide_empty' => false
        ) );

        $this->settings['calendar_selector']          = isset( $atts['calendar_selector'] ) ? $atts['calendar_selector'] : $this->default_values['calendar_selector'];
        $this->settings['calendar_main_color']        = isset( $atts['calendar_main_color'] ) ? $atts['calendar_main_color'] : $this->default_values['calendar_main_color'];
        $this->settings['calendar_main_font']         = isset( $atts['calendar_main_font'] ) ? $atts['calendar_main_font'] : $this->default_values['calendar_main_font'];
        $this->settings['calendar_main_font_color']   = isset( $atts['calendar_main_font_color'] ) ? $atts['calendar_main_font_color'] : $this->default_values['calendar_main_font_color'];
        $this->settings['month_row_color']            = isset( $atts['month_row_color'] ) ? $atts['month_row_color'] : $this->default_values['month_row_color'];
        $this->settings['month_row_font']             = isset( $atts['month_row_font'] ) ? $atts['month_row_font'] : $this->default_values['month_row_font'];
        $this->settings['month_row_font_color']       = isset( $atts['month_row_font_color'] ) ? $atts['month_row_font_color'] : $this->default_values['month_row_font_color'];
        $this->settings['day_row_color']              = isset( $atts['day_row_color'] ) ? $atts['day_row_color'] : $this->default_values['day_row_color'];
        $this->settings['day_row_font']               = isset( $atts['day_row_font'] ) ? $atts['day_row_font'] : $this->default_values['day_row_font'];
        $this->settings['day_row_font_color']         = isset( $atts['day_row_font_color'] ) ? $atts['day_row_font_color'] : $this->default_values['day_row_font_color'];
        $this->settings['normal_day_cell_color']      = isset( $atts['normal_day_cell_color'] ) ? $atts['normal_day_cell_color'] : $this->default_values['normal_day_cell_color'];
        $this->settings['normal_day_cell_font']       = isset( $atts['normal_day_cell_font'] ) ? $atts['normal_day_cell_font'] : $this->default_values['normal_day_cell_font'];
        $this->settings['normal_day_cell_font_color'] = isset( $atts['normal_day_cell_font_color'] ) ? $atts['normal_day_cell_font_color'] : $this->default_values['normal_day_cell_font_color'];
        $this->settings['hover_day_cell_color']       = isset( $atts['hover_day_cell_color'] ) ? $atts['hover_day_cell_color'] : $this->default_values['hover_day_cell_color'];
        $this->settings['active_day_cell_color']      = isset( $atts['active_day_cell_color'] ) ? $atts['active_day_cell_color'] : $this->default_values['active_day_cell_color'];
        $this->settings['active_day_cell_font']       = isset( $atts['active_day_cell_font'] ) ? $atts['active_day_cell_font'] : $this->default_values['active_day_cell_font'];
        $this->settings['active_day_cell_font_color'] = isset( $atts['active_day_cell_font_color'] ) ? $atts['active_day_cell_font_color'] : $this->default_values['active_day_cell_font_color'];
        $this->settings['button_before_color']        = isset( $atts['button_before_color'] ) ? $atts['button_before_color'] : $this->default_values['button_before_color'];
        $this->settings['button_after_color']         = isset( $atts['button_after_color'] ) ? $atts['button_after_color'] : $this->default_values['button_after_color'];
        $this->settings['button_font']                = isset( $atts['button_font'] ) ? $atts['button_font'] : $this->default_values['button_font'];
        $this->settings['button_font_color']          = isset( $atts['button_font_color'] ) ? $atts['button_font_color'] : $this->default_values['button_font_color'];
        $this->settings['admin_label']                = isset( $atts['admin_label'] ) ? $atts['admin_label'] : $this->default_values['admin_label'];
        $this->settings['module_id']                  = $this->shortcode_atts['module_id'];
        $this->settings['module_class']               = $this->shortcode_atts['module_class'];

        $nameSelected = $this->settings['calendar_selector'];
        $id           = 0;

        foreach ( $calendars as $cal ) {
            if ( $cal->name == $nameSelected ) {
                $id = $cal->term_id;
            }
        }

        $local_time = current_time( 'timestamp' );
        $year       = date_i18n( 'Y', $local_time );
        $month      = date_i18n( 'm', $local_time );

        $module_class = ET_Builder_Element::add_module_order_class( $this->settings['module_class'], $function_name );

        $calendar_main_font_array = explode( '|', $this->settings['calendar_main_font'] );
        $calendar_main_font_url   = str_replace( ' ', '+', $calendar_main_font_array[0] );

        $month_row_font_array = explode( '|', $this->settings['month_row_font'] );
        $month_row_font_url   = str_replace( ' ', '+', $month_row_font_array[0] );

        $day_row_font_array = explode( '|', $this->settings['day_row_font'] );
        $day_row_font_url   = str_replace( ' ', '+', $day_row_font_array[0] );

        $day_cell_normal_font_array = explode( '|', $this->settings['normal_day_cell_font'] );
        $day_cell_normal_font_url   = str_replace( ' ', '+', $day_cell_normal_font_array[0] );

        $day_cell_active_font_array = explode( '|', $this->settings['active_day_cell_font'] );
        $day_cell_active_font_url   = str_replace( ' ', '+', $day_cell_active_font_array[0] );

        $button_font_array = explode( '|', $this->settings['button_font'] );
        $button_font_url   = str_replace( ' ', '+', $button_font_array[0] );

        //Calendar Main Color
        ET_Builder_Element::set_style( $function_name, array(
            'selector' => 'div.booked-calendar-shortcode-wrap.calendar-wrap-' . $id . ', 
			table#calendar-' . $id . '.booked-calendar tbody tr.entryBlock, 
			table#calendar-' . $id . '.booked-calendar tbody tr.entryBlock div.booked-appt-list.shown, 
			body .booked-modal.calendar-' . $id . ' .bm-window, 
			body .booked-modal.calendar-' . $id . ' .booked-form, 
			body .booked-modal.calendar-' . $id . ' .booked-appointments',

            'declaration' => sprintf(
                'background: %1$s !important;',
                esc_html( $this->settings['calendar_main_color'] )
            ),
        ) );

        //Calendar Main Font
        echo  "<style>@import url(https://fonts.googleapis.com/css?family=" . $calendar_main_font_url . ");</style>";
        ET_Builder_Element::set_style( $function_name, array(
            'selector' => 'div.booked-calendar-shortcode-wrap.calendar-wrap-' . $id . ', 
			table#calendar-' . $id . '.booked-calendar tbody tr.entryBlock, 
			table#calendar-' . $id . '.booked-calendar tbody tr.entryBlock div.booked-appt-list.shown, 
			body .booked-modal.calendar-' . $id . ' .bm-window, 
			body .booked-modal.calendar-' . $id . ' .booked-form, 
			body .booked-modal.calendar-' . $id . ' .booked-appointments',

            'declaration' => sprintf(
                'font-family: %1$s !important;',
                esc_html( $calendar_main_font_array[0] )
            ),
        ) );

        //Calendar Main Font Bold
        if ( '' !== $calendar_main_font_array[1] ) {
            ET_Builder_Element::set_style( $function_name, array(
                'selector' => 'div.booked-calendar-shortcode-wrap.calendar-wrap-' . $id . ', 
				table#calendar-' . $id . '.booked-calendar tbody tr.entryBlock, 
				table#calendar-' . $id . '.booked-calendar tbody tr.entryBlock div.booked-appt-list.shown,
				body .booked-modal.calendar-' . $id . ' .bm-window, 
				body .booked-modal.calendar-' . $id . ' .booked-form, 
				body .booked-modal.calendar-' . $id . ' .booked-appointments',

                'declaration' => sprintf(
                    'font-weight: bold  !important;'
                ),
            ) );
        }

        //Calendar Main Font italic
        if ( '' !== $calendar_main_font_array[2] ) {
            ET_Builder_Element::set_style( $function_name, array(
                'selector' => 'div.booked-calendar-shortcode-wrap.calendar-wrap-' . $id . ', 
				table#calendar-' . $id . '.booked-calendar tbody tr.entryBlock, 
				table#calendar-' . $id . '.booked-calendar tbody tr.entryBlock div.booked-appt-list.shown, 
				body .booked-modal.calendar-' . $id . ' .bm-window, 
				body .booked-modal.calendar-' . $id . ' .booked-form, 
				body .booked-modal.calendar-' . $id . ' .booked-appointments',

                'declaration' => sprintf(
                    'font-style: italic  !important;'
                ),
            ) );
        }

        //Calendar Main Font uppercase
        if ( '' !== $calendar_main_font_array[3] ) {
            ET_Builder_Element::set_style( $function_name, array(
                'selector' => 'div.booked-calendar-shortcode-wrap.calendar-wrap-' . $id . ', 
				table#calendar-' . $id . '.booked-calendar tbody tr.entryBlock, 
				table#calendar-' . $id . '.booked-calendar tbody tr.entryBlock div.booked-appt-list.shown,
				body .booked-modal.calendar-' . $id . ' .bm-window, 
				body .booked-modal.calendar-' . $id . ' .booked-form, 
				body .booked-modal.calendar-' . $id . ' .booked-appointments',

                'declaration' => sprintf(
                    'text-transform: uppercase !important;'
                ),
            ) );
        }

        //Calendar Main Font underline
        if ( '' !== $calendar_main_font_array[4] ) {
            ET_Builder_Element::set_style( $function_name, array(
                'selector' => 'div.booked-calendar-shortcode-wrap.calendar-wrap-' . $id . ', 
				table#calendar-' . $id . '.booked-calendar tbody tr.entryBlock, 
				table#calendar-' . $id . '.booked-calendar tbody tr.entryBlock div.booked-appt-list.shown, 
				body .booked-modal.calendar-' . $id . ' .bm-window, 
				body .booked-modal.calendar-' . $id . ' .booked-form, 
				body .booked-modal.calendar-' . $id . ' .booked-appointments',

                'declaration' => sprintf(
                    'text-decoration: underline !important;'
                ),
            ) );
        }

        //Calendar Font Color
        ET_Builder_Element::set_style( $function_name, array(
            'selector' => 'div.booked-calendar-shortcode-wrap.calendar-wrap-' . $id . ', 
			table#calendar-' . $id . '.booked-calendar tbody tr.entryBlock, 
			table#calendar-' . $id . '.booked-calendar tbody tr.entryBlock div.booked-appt-list.shown, 
			body .booked-modal.calendar-' . $id . ' .bm-window, 
			body .booked-modal.calendar-' . $id . ' .booked-form, 
			body .booked-modal.calendar-' . $id . ' .booked-appointments',

            'declaration' => sprintf(
                'color: %1$s !important;',
                esc_html( $this->settings['calendar_main_font_color'] )
            ),
        ) );

        //Month Row Color
        ET_Builder_Element::set_style( $function_name, array(
            'selector'    => 'table#calendar-' . $id . '.booked-calendar thead tr.month-' . $id,
            'declaration' => sprintf(
                'background: %1$s !important;',
                esc_html( $this->settings['month_row_color'] )
            ),
        ) );

        //Month Row Font
        echo "<style>@import url(https://fonts.googleapis.com/css?family=" . $month_row_font_url . ");</style>";
        ET_Builder_Element::set_style( $function_name, array(
            'selector'    => 'table#calendar-' . $id . '.booked-calendar thead tr.month-' . $id . ' th',
            'declaration' => sprintf(
                'font-family: %1$s !important;',
                esc_html( $month_row_font_array[0] )
            ),
        ) );

        //Month Row Font Bold
        if ( '' !== $month_row_font_array[1] ) {
            ET_Builder_Element::set_style( $function_name, array(
                'selector'    => 'table#calendar-' . $id . '.booked-calendar thead tr.month-' . $id . ' th',
                'declaration' => sprintf(
                    'font-weight: bold  !important;'
                ),
            ) );
        }

        //Month Row Font italic
        if ( '' !== $month_row_font_array[2] ) {
            ET_Builder_Element::set_style( $function_name, array(
                'selector'    => 'table#calendar-' . $id . '.booked-calendar thead tr.month-' . $id . ' th',
                'declaration' => sprintf(
                    'font-style: italic  !important;'
                ),
            ) );
        }

        //Month Row Font uppercase
        if ( '' !== $month_row_font_array[3] ) {
            ET_Builder_Element::set_style( $function_name, array(
                'selector'    => 'table#calendar-' . $id . '.booked-calendar thead tr.month-' . $id . ' th',
                'declaration' => sprintf(
                    'text-transform: uppercase !important;'
                ),
            ) );
        }

        //Month Row Font underline
        if ( '' !== $month_row_font_array[4] ) {
            ET_Builder_Element::set_style( $function_name, array(
                'selector'    => 'table#calendar-' . $id . '.booked-calendar thead tr.month-' . $id . ' th',
                'declaration' => sprintf(
                    'text-decoration: underline !important;'
                ),
            ) );
        }

        //Month Row Font Color
        ET_Builder_Element::set_style( $function_name, array(
            'selector'    => 'table#calendar-' . $id . '.booked-calendar thead tr.month-' . $id . ' th',
            'declaration' => sprintf(
                'color: %1$s !important;',
                esc_html( $this->settings['month_row_font_color'] )
            ),
        ) );

        //Day Row Color
        ET_Builder_Element::set_style( $function_name, array(
            'selector'    => 'table#calendar-' . $id . '.booked-calendar thead tr.days-' . $id,
            'declaration' => sprintf(
                'background: %1$s !important;',
                esc_html( $this->settings['day_row_color'] )
            ),
        ) );

        //Day Row Font
        echo "<style>@import url(https://fonts.googleapis.com/css?family=" . $day_row_font_url . ");</style>";
        ET_Builder_Element::set_style( $function_name, array(
            'selector'    => 'table#calendar-' . $id . '.booked-calendar thead tr.days-' . $id . ' th',
            'declaration' => sprintf(
                'font-family: %1$s !important;',
                esc_html( $day_row_font_array[0] )
            ),
        ) );

        //Day Row Font Bold
        if ( '' !== $day_row_font_array[1] ) {
            ET_Builder_Element::set_style( $function_name, array(
                'selector'    => 'table#calendar-' . $id . '.booked-calendar thead tr.days-' . $id . ' th',
                'declaration' => sprintf(
                    'font-weight: bold  !important;'
                ),
            ) );
        }

        //Day Row Font italic
        if ( '' !== $day_row_font_array[2] ) {
            ET_Builder_Element::set_style( $function_name, array(
                'selector'    => 'table#calendar-' . $id . '.booked-calendar thead tr.days-' . $id . ' th',
                'declaration' => sprintf(
                    'font-style: italic  !important;'
                ),
            ) );
        }

        //Day Row Font uppercase
        if ( '' !== $day_row_font_array[3] ) {
            ET_Builder_Element::set_style( $function_name, array(
                'selector'    => 'table#calendar-' . $id . '.booked-calendar thead tr.days-' . $id . ' th',
                'declaration' => sprintf(
                    'text-transform: uppercase !important;'
                ),
            ) );
        }

        //Day Row Font underline
        if ( '' !== $day_row_font_array[4] ) {
            ET_Builder_Element::set_style( $function_name, array(
                'selector'    => 'table#calendar-' . $id . '.booked-calendar thead tr.days-' . $id . ' th',
                'declaration' => sprintf(
                    'text-decoration: underline !important;'
                ),
            ) );
        }

        //Day Row Font Color
        ET_Builder_Element::set_style( $function_name, array(
            'selector'    => 'table#calendar-' . $id . '.booked-calendar thead tr.days-' . $id . ' th',
            'declaration' => sprintf(
                'color: %1$s !important;',
                esc_html( $this->settings['day_row_font_color'] )
            ),
        ) );

        //Normal day cell Color
        ET_Builder_Element::set_style( $function_name, array(
            'selector'    => 'table#calendar-' . $id . '.booked-calendar tbody td span#date-' . $id . '.date',
            'declaration' => sprintf(
                'background: %1$s !important;',
                esc_html( $this->settings['normal_day_cell_color'] )
            ),
        ) );

        //Normal day cell Font
        echo "<style>@import url(https://fonts.googleapis.com/css?family=" . $day_cell_normal_font_url . ");</style>";
        ET_Builder_Element::set_style( $function_name, array(
            'selector'    => 'table#calendar-' . $id . '.booked-calendar tbody td.prev-date span#date-' . $id . '.date',
            'declaration' => sprintf(
                'font-family: %1$s !important;',
                esc_html( $day_cell_normal_font_array[0] )
            ),
        ) );

        //Normal day cell Font Bold
        if ( '' !== $day_cell_normal_font_array[1] ) {
            ET_Builder_Element::set_style( $function_name, array(
                'selector'    => 'table#calendar-' . $id . '.booked-calendar tbody td.prev-date span#date-' . $id . '.date',
                'declaration' => sprintf(
                    'font-weight: bold  !important;'
                ),
            ) );
        }

        //Normal day cell Font italic
        if ( '' !== $day_cell_normal_font_array[2] ) {
            ET_Builder_Element::set_style( $function_name, array(
                'selector'    => 'table#calendar-' . $id . '.booked-calendar tbody td.prev-date span#date-' . $id . '.date',
                'declaration' => sprintf(
                    'font-style: italic  !important;'
                ),
            ) );
        }

        //Normal day cell Font uppercase
        if ( '' !== $day_cell_normal_font_array[3] ) {
            ET_Builder_Element::set_style( $function_name, array(
                'selector'    => 'table#calendar-' . $id . '.booked-calendar tbody td.prev-date span#date-' . $id . '.date',
                'declaration' => sprintf(
                    'text-transform: uppercase !important;'
                ),
            ) );
        }

        //Normal day cell Font underline
        if ( '' !== $day_cell_normal_font_array[4] ) {
            ET_Builder_Element::set_style( $function_name, array(
                'selector'    => 'table#calendar-' . $id . '.booked-calendar tbody td.prev-date span#date-' . $id . '.date',
                'declaration' => sprintf(
                    'text-decoration: underline !important;'
                ),
            ) );
        }

        //Normal day cell Font Color
        ET_Builder_Element::set_style( $function_name, array(
            'selector'    => 'table#calendar-' . $id . '.booked-calendar tbody td.prev-date span#date-' . $id . '.date',
            'declaration' => sprintf(
                'color: %1$s !important;',
                esc_html( $this->settings['normal_day_cell_font_color'] )
            ),
        ) );

        //Hover day cell Color
        ET_Builder_Element::set_style( $function_name, array(
            'selector'    => 'table#calendar-' . $id . '.booked-calendar tbody td.prev-date span#date-' . $id . '.date:hover',
            'declaration' => sprintf(
                'background: %1$s !important;',
                esc_html( $this->settings['hover_day_cell_color'] )
            ),
        ) );

        //Active day cell Color
        ET_Builder_Element::set_style( $function_name, array(
            'selector'    => 'table#calendar-' . $id . '.booked-calendar tbody td span#date-' . $id . '.date.tooltipster-' . $id,
            'declaration' => sprintf(
                'background: %1$s !important;',
                esc_html( $this->settings['active_day_cell_color'] )
            ),
        ) );

        //Active day cell Font
        echo "<style>@import url(https://fonts.googleapis.com/css?family=" . $day_cell_active_font_url . ");</style>";
        ET_Builder_Element::set_style( $function_name, array(
            'selector'    => 'table#calendar-' . $id . '.booked-calendar tbody td span#date-' . $id . '.date.tooltipster-' . $id,
            'declaration' => sprintf(
                'font-family: %1$s !important;',
                esc_html( $day_cell_active_font_array[0] )
            ),
        ) );

        //Active day cell Font Bold
        if ( '' !== $day_cell_active_font_array[1] ) {
            ET_Builder_Element::set_style( $function_name, array(
                'selector'    => 'table#calendar-' . $id . '.booked-calendar tbody td span#date-' . $id . '.date.tooltipster-' . $id,
                'declaration' => sprintf(
                    'font-weight: bold  !important;'
                ),
            ) );
        }

        //Active day cell Font italic
        if ( '' !== $day_cell_active_font_array[2] ) {
            ET_Builder_Element::set_style( $function_name, array(
                'selector'    => 'table#calendar-' . $id . '.booked-calendar tbody td span#date-' . $id . '.date.tooltipster-' . $id,
                'declaration' => sprintf(
                    'font-style: italic  !important;'
                ),
            ) );
        }

        //Active day cell Font uppercase
        if ( '' !== $day_cell_active_font_array[3] ) {
            ET_Builder_Element::set_style( $function_name, array(
                'selector'    => 'table#calendar-' . $id . '.booked-calendar tbody td span#date-' . $id . '.date.tooltipster-' . $id,
                'declaration' => sprintf(
                    'text-transform: uppercase !important;'
                ),
            ) );
        }

        //Active day cell Font underline
        if ( '' !== $day_cell_active_font_array[4] ) {
            ET_Builder_Element::set_style( $function_name, array(
                'selector'    => 'table#calendar-' . $id . '.booked-calendar tbody td span#date-' . $id . '.date.tooltipster-' . $id,
                'declaration' => sprintf(
                    'text-decoration: underline !important;'
                ),
            ) );
        }

        //Active day cell Font Color
        ET_Builder_Element::set_style( $function_name, array(
            'selector'    => 'table#calendar-' . $id . '.booked-calendar tbody td span#date-' . $id . '.date.tooltipster-' . $id,
            'declaration' => sprintf(
                'color: %1$s !important;',
                esc_html( $this->settings['active_day_cell_font_color'] )
            ),
        ) );

        //Button before Color
        ET_Builder_Element::set_style( $function_name, array(
            'selector'    => 'button#book-button-' . $id . '.new-appt.button, #submit-request-appointment-' . $id,
            'declaration' => sprintf(
                'background: %1$s !important;',
                esc_html( $this->settings['button_before_color'] )
            ),
        ) );

        //Button after Color
        ET_Builder_Element::set_style( $function_name, array(
            'selector'    => 'button#book-button-' . $id . '.new-appt.button:hover, #submit-request-appointment-' . $id . ':hover',
            'declaration' => sprintf(
                'background: %1$s !important;',
                esc_html( $this->settings['button_after_color'] )
            ),
        ) );

        //Button Font
        echo "<style>@import url(https://fonts.googleapis.com/css?family=" . $button_font_url . ");</style>";
        ET_Builder_Element::set_style( $function_name, array(
            'selector'    => 'button#book-button-' . $id . '.new-appt.button, #submit-request-appointment-' . $id,
            'declaration' => sprintf(
                'font-family: %1$s !important;',
                esc_html( $button_font_array[0] )
            ),
        ) );

        //Button Font Bold
        if ( '' !== $button_font_array[1] ) {
            ET_Builder_Element::set_style( $function_name, array(
                'selector'    => 'button#book-button-' . $id . '.new-appt.button, #submit-request-appointment-' . $id,
                'declaration' => sprintf(
                    'font-weight: bold  !important;'
                ),
            ) );
        }

        //Button Font italic
        if ( '' !== $button_font_array[2] ) {
            ET_Builder_Element::set_style( $function_name, array(
                'selector'    => 'button#book-button-' . $id . '.new-appt.button, #submit-request-appointment-' . $id,
                'declaration' => sprintf(
                    'font-style: italic  !important;'
                ),
            ) );
        }

        //Button Font uppercase
        if ( '' !== $button_font_array[3] ) {
            ET_Builder_Element::set_style( $function_name, array(
                'selector'    => 'button#book-button-' . $id . '.new-appt.button, #submit-request-appointment-' . $id,
                'declaration' => sprintf(
                    'text-transform: uppercase !important;'
                ),
            ) );
        }

        //Active day cell Font underline
        if ( '' !== $button_font_array[4] ) {
            ET_Builder_Element::set_style( $function_name, array(
                'selector'    => 'button#book-button-' . $id . '.new-appt.button, #submit-request-appointment-' . $id,
                'declaration' => sprintf(
                    'text-decoration: underline !important;'
                ),
            ) );
        }

        //Button Font Color
        ET_Builder_Element::set_style( $function_name, array(
            'selector'    => 'button#book-button-' . $id . '.new-appt.button, #submit-request-appointment-' . $id,
            'declaration' => sprintf(
                'color: %1$s !important;',
                esc_html( $this->settings['button_font'] )
            ),
        ) );


        $options = array();

        $options[$id.'-calendarColor'] = isset( $atts['calendar_main_color'] ) ? $atts['calendar_main_color'] : $this->default_values['calendar_main_color'];
        $options[$id.'-monthRowColor'] = isset( $atts['month_row_color'] ) ? $atts['month_row_color'] : $this->default_values['month_row_color'];
        $options[$id.'-dayRowColor'] = isset( $atts['day_row_color'] ) ? $atts['day_row_color'] : $this->default_values['day_row_color'];
        $options[$id.'-buttonBeforeColor'] = isset( $atts['button_before_color'] ) ? $atts['button_before_color'] : $this->default_values['button_before_color'];
        $options[$id.'-buttonAfterColor'] = isset( $atts['button_after_color'] ) ? $atts['button_after_color'] : $this->default_values['button_after_color'];
        $options[$id.'-activeDayCellColor'] = isset( $atts['active_day_cell_color'] ) ? $atts['active_day_cell_color'] : $this->default_values['active_day_cell_color'];
        $options[$id.'-normalDayCellColor'] = isset( $atts['normal_day_cell_color'] ) ? $atts['normal_day_cell_color'] : $this->default_values['normal_day_cell_color'];
        $options[$id.'-hoverDayCellColor'] = isset( $atts['hover_day_cell_color'] ) ? $atts['hover_day_cell_color'] : $this->default_values['hover_day_cell_color'];
        $options[$id.'-calendarFont'] = isset( $atts['calendar_main_font'] ) ? $atts['calendar_main_font'] : $this->default_values['calendar_main_font'];
        $options[$id.'-calendarFontColor'] = isset( $atts['calendar_main_font_color'] ) ? $atts['calendar_main_font_color'] : $this->default_values['calendar_main_font_color'];
        $options[$id.'-monthRowFont'] = isset( $atts['month_row_font'] ) ? $atts['month_row_font'] : $this->default_values['month_row_font'];
        $options[$id.'-monthRowFontColor'] = isset( $atts['month_row_font_color'] ) ? $atts['month_row_font_color'] : $this->default_values['month_row_font_color'];
        $options[$id.'-dayRowFont'] = isset( $atts['day_row_font'] ) ? $atts['day_row_font'] : $this->default_values['day_row_font'];
        $options[$id.'-dayRowFontColor'] = isset( $atts['day_row_font_color'] ) ? $atts['day_row_font_color'] : $this->default_values['day_row_font_color'];
        $options[$id.'-normalDayCellFont'] = isset( $atts['normal_day_cell_font'] ) ? $atts['normal_day_cell_font'] : $this->default_values['normal_day_cell_font'];
        $options[$id.'-normalDayCellFontColor'] = isset( $atts['normal_day_cell_font_color'] ) ? $atts['normal_day_cell_font_color'] : $this->default_values['normal_day_cell_font_color'];
        $options[$id.'-activeDayCellFont'] = isset( $atts['active_day_cell_font'] ) ? $atts['active_day_cell_font'] : $this->default_values['active_day_cell_font'];
        $options[$id.'-activeDayCellFontColor'] = isset( $atts['active_day_cell_font_color'] ) ? $atts['active_day_cell_font_color'] : $this->default_values['active_day_cell_font_color'];
        $options[$id.'-buttonFont'] = isset( $atts['button_font'] ) ? $atts['button_font'] : $this->default_values['button_font'];
        $options[$id.'-buttonFontColor'] = isset( $atts['button_font_color'] ) ? $atts['button_font_color'] : $this->default_values['button_font_color'];
        $options[$id.'-adminLabel'] = isset( $atts['admin_label'] ) ? $atts['admin_label'] : $this->default_values['admin_label'];
        $options[$id.'-hoverDayCellColor'] = isset( $atts['hover_day_cell_color'] ) ? $atts['hover_day_cell_color'] : $this->default_values['hover_day_cell_color'];


        $output = booked_fe_calendar_divi( $year, $month, $id, false, $options );

        return $output;
    }


}

new GWP_Custom_Module_BookedCalendar;

class GWP_Custom_Module_AgentFrontEnd extends ET_Builder_Module {

    public $vb_support = "on";
    public  $slug;
   // public $fp_support = true;

    function init() {
        $this->name = esc_html__( 'Booked Agent Frontend', 'et_builder' );
        $this->slug = 'et_pb_booked_agent';

        $this->CalendarSelectorOptions = array();
        $calendars                     = get_terms( 'booked_custom_calendars', array(
            'orderby'    => 'name',
            'order'      => 'ASC',
            'hide_empty' => false
        ) );

        foreach ( $calendars as $cal ) {
            array_push( $this->CalendarSelectorOptions, $cal->name );
        }

        $this->whitelisted_fields = array(
            'main_color',
            'second_color',
            'button_color',
            'background_color',
            'header_font',
            'body_font',
            'header_font_color',
            'body_font_color',
            'admin_label',
            'agent_code',
            'content'
        );

        $this->fields_defaults = array(
            'main_color'       => '#8300e9',
            'second_color'     => "#edf000",
            'button_color'     => '#e09900',
            'background_color' => "#FFFFFF",
            'header_font'      => 'Arial',
            'body_font'        => 'Arial',
            'header_font_color' => '#FFFFFF',
            'body_font_color'   => '#FFFFFF',
            'admin_label'      => 'AgentFont',
            'css_url'          => BOOKED_PLUGIN_URL.'/assets/css/style_front.php',
            'content'          => ""
        );

        $this->main_css_element = '%%order_class%%  .dcm_post';
    }

    function get_fields() {
        $fields = array(
            'help_text'        => array(
                'label'        => '',
                'type'         => "hidden",
            ),
            'main_color'       => array(
                'label'           => esc_html__( 'Main Color', 'et_builder' ),
                'type'            => 'color-alpha',
                'option_category' => 'configuration',
                'default'         => $this->fields_defaults['mainColor'],
                'description'     => esc_html__( 'Main Color', 'et_builder' ),
            ),
            'second_color'     => array(
                'label'           => esc_html__( 'Second Color', 'et_builder' ),
                'type'            => 'color-alpha',
                'option_category' => 'configuration',
                'default'         => $this->fields_defaults['secondColor'],
                'description'     => esc_html__( 'Second Color', 'et_builder' ),
            ),
            'background_color' => array(
                'label'           => esc_html__( 'Background Color', 'et_builder' ),
                'type'            => 'color-alpha',
                'option_category' => 'configuration',
                'default'         => $this->fields_defaults['secondColor'],
                'description'     => esc_html__( 'Background Color', 'et_builder' ),
            ),
            'button_color'     => array(
                'label'           => esc_html__( 'Buttons Color', 'et_builder' ),
                'type'            => 'color-alpha',
                'option_category' => 'configuration',
                'default'         => $this->fields_defaults['buttonColor'],
                'description'     => esc_html__( 'Buttons Color.', 'et_builder' ),
            ),
            'header_font'      => array(
                'label'           => esc_html__( 'Header Font', 'et_builder' ),
                'type'            => 'font',
                'option_category' => 'configuration',
                'default'         => $this->fields_defaults['headerFont'],
                'description'     => esc_html__( 'Header Font', 'et_builder' ),
            ),
            'body_font'        => array(
                'label'           => esc_html__( 'Body Font', 'et_builder' ),
                'type'            => 'font',
                'option_category' => 'configuration',
                'default'         => $this->fields_defaults['bodyFont'],
                'description'     => esc_html__( 'Body Font', 'et_builder' ),
            ),
            'header_font_color' => array(
                'label'           => esc_html__( 'Header font Color', 'et_builder' ),
                'type'            => 'color-alpha',
                'option_category' => 'configuration',
                'default'         => $this->fields_defaults['headerFontColor'],
                'description'     => esc_html__( 'Header font Color.', 'et_builder' ),
            ),
            'body_font_color'   => array(
                'label'           => esc_html__( 'Body font Color', 'et_builder' ),
                'type'            => 'color-alpha',
                'option_category' => 'configuration',
                'default'         => $this->fields_defaults['bodyFontColor'],
                'description'     => esc_html__( 'Body font Color.', 'et_builder' ),
            ),
            'admin_label'      => array(
                'label'           => esc_html__( 'Admin Label', 'et_builder' ),
                'type'            => 'text',
                'option_category' => 'configuration',
                'default'         => $this->fields_defaults['adminLabel'],
                'description'     => esc_html__( 'This will change the label of the module in the builder for easy identification.', 'et_builder' ),
            ),
            'agent_code'        => array(
                'label' => '',
                'type'  => "hidden",
                'default' => ''
            ),
            'css_url'          => array(
                'label'    => '',
                'type'     => 'hidden',
                'default'  => BOOKED_PLUGIN_URL.'/assets/css/style_react.php',
            )
        );

        return $fields;
    }
/*
    function render($attrs, $content = "", $render_slug) {
        return do_shortcode( '[booked-agentfront]' );
    }
*/
    public function before_render()
    {
        $atts = $this->props;
        $output = do_shortcode("[booked-agentfront]");
        $this->props['agent_code'] = $output;
    
        }

    function shortcode_callback( $atts, $content = null, $function_name ) {

        if ( $atts['second_color'] != '' ) {
            update_option( 'booked_dark_color', $atts['second_color'] );
        } else {
            update_option( 'booked_dark_color', $this->fields_defaults['second_color'] );
        }

        if ( $atts['main_color'] != '' ) {
            update_option( 'booked_light_color', $atts['main_color'] );
        } else {
            update_option( 'booked_light_color', $this->fields_defaults['main_color'] );
        }

        if ( $atts['button_color'] != '' ) {
            update_option( 'booked_button_color', $atts['button_color'] );
        } else {
            update_option( 'booked_button_color', $this->fields_defaults['button_color'] );
        }

        if ( $atts['background_color'] != '' ) {
            update_option( 'backgroundcolor', $atts['background_color'] );
        } else {
            update_option( 'backgroundcolor', $this->fields_defaults['background_color'] );
        }

        if ( $atts['header_font'] != '' ) {
            update_option( 'header_font', $atts['header_font'] );
        } else {
            update_option( 'header_font', $this->fields_defaults['header_font'] );
        }

        if ( $atts['body_font'] != '' ) {
            update_option( 'body_font', $atts['body_font'] );
        } else {
            update_option( 'body_font', $this->fields_defaults['body_font'] );
        }

        if ( $atts['header_font_color'] != '' ) {
            update_option( 'header_fontcolor', $atts['header_font_color'] );
        } else {
            update_option( 'header_fontcolor', $this->fields_defaults['header_font_color'] );
        }

        if ( $atts['body_font_color'] != '' ) {
            update_option( 'body_fontcolor', $atts['body_font_color'] );
        } else {
            update_option( 'body_fontcolor', $this->fields_defaults['body_font_color'] );
        }


        return do_shortcode( '[booked-agentfront]');
    }


}

new GWP_Custom_Module_AgentFrontEnd();
