<?php
/**
 * @Package: WordPress Plugin
 * @Subpackage: Ultra Portfolio
 * @Since: Ultra Portfolio 1.0
 * @Current Version: Ultra Portfolio 3.1
 * @WordPress Version: 3.5 or above
 * This file is part of Ultra Portofolio WordPress Plugin.
 */
global $uport_db_version;
$uport_db_version = "3.1";

function uport_install_demos_page() {
    global $wpdb;
    global $uport_db_version;
    ?>
    <h2 class='uport_head'><?php _e('Ultra Portfolio - Install Demos', 'uport-framework'); ?></h2>
    <?php
    if (isset($_GET['install']) && $_GET['install'] == 'true') {
        include("uport-demo-sql.php");
        $ret1 = uport_demo_uport();
        $ret2 = uport_demo_categories();
        $ret3 = uport_demo_items();

        if ($ret1 && $ret2 && $ret3) {
            echo "<br>Demos Installed Successfully.<br>Please also import media-library-demo.xml file, which is included with the main downloaded package. It will import image, audio and video files for portfolio demos installed. Read documentation for more information. Ignore this message if already imported.";
        } else if ($ret1 && $ret3) {
            echo "<br>Demos Installed Successfully.<br>All or Few Portfolio Categories already seem to exist in database though.<br>Please also import media-library-demo.xml file, which is included with the main downloaded package. It will import image, audio and video files for portfolio demos installed. Read documentation for more information. Ignore this message if already imported.";
        } else {
            echo "<br>Sorry. Demos not Installed.";
        }
    } else {
        ?>
        <br>
        Are you sure, you want to install the demos? <a href='<?php echo esc_url(home_url()); ?>/wp-admin/admin.php?page=uport_install_demos&install=true'>Click to install demos</a>
        <br><br>Note: If demos already installed or exist, new demos will be added in database again.<br>
        <?php
    }
}
?>