<?php
require_once(dirname(__FILE__).'/boot.php');
require_once(SG_LIB_PATH.'SGAuthClient.php');
require_once(SG_PUBLIC_INCLUDE_PATH.'header-new.php');

$auth = SGAuthClient::getInstance();
$products = $auth->getAllUserProducts();
?>
<div class="bg-content bg-content-full-width bg-content-dark1">
	<div class="bg-license-container">
		<p class="bg-text-center">
			<img width="180px" src="<?php echo SG_PUBLIC_URL; ?>img/sgBackupVerticalLogo.png">
		</p>
		<div class="bg-license-content sg-wrapper-less">
			<h1> <?php _backupGuardT('Invalid or unassigned license') ?></h1>

			<?php if ($auth->isAnyLicenseAvailable($products)): ?>
				<p>
					<?php _backupGuardT('Your license could not be validated. Maybe you forgot to link a license to this domain. If that is the case, please link one license below:')?>
				</p>
				<p>
					<select id="product" class="bg-form-control">
						<option value="0"><?php _backupGuardT('Choose a license') ?></option>
						<?php foreach ($products as $product): ?>
						<?php $availableLicenses = $product['licenses']?$product['licenses']-$product['used_licenses']:'Unlimited'; ?>
						<option data-licenses="<?php echo $availableLicenses; ?>" value="<?php echo $product['id']; ?>">
							<?php echo $product['display_name'].' - '.$availableLicenses; ?> license(s) available
						</option>
						<?php endforeach; ?>
					</select>
				</p>
				<p>
					<button id="link-btn" class="btn btn-success"><?php _backupGuardT('Link this domain now') ?></button>
				</p>
			<?php else: ?>
				<p>
					<?php _backupGuardT('Your license could not be validated. It seems that you have already assigned all of your licenses.')?>
				</p>
				<p>
					<?php _backupGuardT('Please login to your dashboard to manage your website urls and release a license to be able to use it.')?>
				</p>
				<p class="bg-license-btn-wrapper">
					<a href="javascript:void(0)" class="bg-try-again" onclick="location.reload()"><?php _backupGuardT('Click here to try again')?></a>
					<a href="<?php echo SG_BACKUP_ADMIN_LOGIN_URL; ?>" target="_blank" class="btn btn-success"><?php _backupGuardT('Login to dashboard')?></a>
				</p>
			<?php endif; ?>
		</div>
	</div>
</div>
<?php
require_once(SG_PUBLIC_INCLUDE_PATH.'footer-new.php');
?>
