<?php
/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */


  /**
   * The "dimensionValues" collection of methods.
   * Typical usage is:
   *  <code>
   *   $dfareportingService = new BackupGuardGoogle_DfareportingService(...);
   *   $dimensionValues = $dfareportingService->dimensionValues;
   *  </code>
   */
  class BackupGuardGoogle_DimensionValuesServiceResource extends BackupGuardGoogle_ServiceResource {

    /**
     * Retrieves list of report dimension values for a list of filters. (dimensionValues.query)
     *
     * @param string $profileId The DFA user profile ID.
     * @param BackupGuardGoogle_DimensionValueRequest $postBody
     * @param array $optParams Optional parameters.
     *
     * @opt_param int maxResults Maximum number of results to return.
     * @opt_param string pageToken The value of the nextToken from the previous result page.
     * @return BackupGuardGoogle_DimensionValueList
     */
    public function query($profileId, BackupGuardGoogle_DimensionValueRequest $postBody, $optParams = array()) {
      $params = array('profileId' => $profileId, 'postBody' => $postBody);
      $params = array_merge($params, $optParams);
      $data = $this->__call('query', array($params));
      if ($this->useObjects()) {
        return new BackupGuardGoogle_DimensionValueList($data);
      } else {
        return $data;
      }
    }
  }

  /**
   * The "files" collection of methods.
   * Typical usage is:
   *  <code>
   *   $dfareportingService = new BackupGuardGoogle_DfareportingService(...);
   *   $files = $dfareportingService->files;
   *  </code>
   */
  class BackupGuardGoogle_FilesServiceResource extends BackupGuardGoogle_ServiceResource {

    /**
     * Retrieves a report file by its report ID and file ID. (files.get)
     *
     * @param string $reportId The ID of the report.
     * @param string $fileId The ID of the report file.
     * @param array $optParams Optional parameters.
     * @return BackupGuardGoogle_DfareportingFile
     */
    public function get($reportId, $fileId, $optParams = array()) {
      $params = array('reportId' => $reportId, 'fileId' => $fileId);
      $params = array_merge($params, $optParams);
      $data = $this->__call('get', array($params));
      if ($this->useObjects()) {
        return new BackupGuardGoogle_DfareportingFile($data);
      } else {
        return $data;
      }
    }
    /**
     * Lists files for a user profile. (files.list)
     *
     * @param string $profileId The DFA profile ID.
     * @param array $optParams Optional parameters.
     *
     * @opt_param int maxResults Maximum number of results to return.
     * @opt_param string pageToken The value of the nextToken from the previous result page.
     * @opt_param string scope The scope that defines which results are returned, default is 'MINE'.
     * @opt_param string sortField The field by which to sort the list.
     * @opt_param string sortOrder Order of sorted results, default is 'DESCENDING'.
     * @return BackupGuardGoogle_FileList
     */
    public function listFiles($profileId, $optParams = array()) {
      $params = array('profileId' => $profileId);
      $params = array_merge($params, $optParams);
      $data = $this->__call('list', array($params));
      if ($this->useObjects()) {
        return new BackupGuardGoogle_FileList($data);
      } else {
        return $data;
      }
    }
  }

  /**
   * The "reports" collection of methods.
   * Typical usage is:
   *  <code>
   *   $dfareportingService = new BackupGuardGoogle_DfareportingService(...);
   *   $reports = $dfareportingService->reports;
   *  </code>
   */
  class BackupGuardGoogle_ReportsServiceResource extends BackupGuardGoogle_ServiceResource {

    /**
     * Deletes a report by its ID. (reports.delete)
     *
     * @param string $profileId The DFA user profile ID.
     * @param string $reportId The ID of the report.
     * @param array $optParams Optional parameters.
     */
    public function delete($profileId, $reportId, $optParams = array()) {
      $params = array('profileId' => $profileId, 'reportId' => $reportId);
      $params = array_merge($params, $optParams);
      $data = $this->__call('delete', array($params));
      return $data;
    }
    /**
     * Retrieves a report by its ID. (reports.get)
     *
     * @param string $profileId The DFA user profile ID.
     * @param string $reportId The ID of the report.
     * @param array $optParams Optional parameters.
     * @return BackupGuardGoogle_Report
     */
    public function get($profileId, $reportId, $optParams = array()) {
      $params = array('profileId' => $profileId, 'reportId' => $reportId);
      $params = array_merge($params, $optParams);
      $data = $this->__call('get', array($params));
      if ($this->useObjects()) {
        return new BackupGuardGoogle_Report($data);
      } else {
        return $data;
      }
    }
    /**
     * Creates a report. (reports.insert)
     *
     * @param string $profileId The DFA user profile ID.
     * @param BackupGuardGoogle_Report $postBody
     * @param array $optParams Optional parameters.
     * @return BackupGuardGoogle_Report
     */
    public function insert($profileId, BackupGuardGoogle_Report $postBody, $optParams = array()) {
      $params = array('profileId' => $profileId, 'postBody' => $postBody);
      $params = array_merge($params, $optParams);
      $data = $this->__call('insert', array($params));
      if ($this->useObjects()) {
        return new BackupGuardGoogle_Report($data);
      } else {
        return $data;
      }
    }
    /**
     * Retrieves list of reports. (reports.list)
     *
     * @param string $profileId The DFA user profile ID.
     * @param array $optParams Optional parameters.
     *
     * @opt_param int maxResults Maximum number of results to return.
     * @opt_param string pageToken The value of the nextToken from the previous result page.
     * @opt_param string scope The scope that defines which results are returned, default is 'MINE'.
     * @opt_param string sortField The field by which to sort the list.
     * @opt_param string sortOrder Order of sorted results, default is 'DESCENDING'.
     * @return BackupGuardGoogle_ReportList
     */
    public function listReports($profileId, $optParams = array()) {
      $params = array('profileId' => $profileId);
      $params = array_merge($params, $optParams);
      $data = $this->__call('list', array($params));
      if ($this->useObjects()) {
        return new BackupGuardGoogle_ReportList($data);
      } else {
        return $data;
      }
    }
    /**
     * Updates a report. This method supports patch semantics. (reports.patch)
     *
     * @param string $profileId The DFA user profile ID.
     * @param string $reportId The ID of the report.
     * @param BackupGuardGoogle_Report $postBody
     * @param array $optParams Optional parameters.
     * @return BackupGuardGoogle_Report
     */
    public function patch($profileId, $reportId, BackupGuardGoogle_Report $postBody, $optParams = array()) {
      $params = array('profileId' => $profileId, 'reportId' => $reportId, 'postBody' => $postBody);
      $params = array_merge($params, $optParams);
      $data = $this->__call('patch', array($params));
      if ($this->useObjects()) {
        return new BackupGuardGoogle_Report($data);
      } else {
        return $data;
      }
    }
    /**
     * Runs a report. (reports.run)
     *
     * @param string $profileId The DFA profile ID.
     * @param string $reportId The ID of the report.
     * @param array $optParams Optional parameters.
     *
     * @opt_param bool synchronous If set and true, tries to run the report synchronously.
     * @return BackupGuardGoogle_DfareportingFile
     */
    public function run($profileId, $reportId, $optParams = array()) {
      $params = array('profileId' => $profileId, 'reportId' => $reportId);
      $params = array_merge($params, $optParams);
      $data = $this->__call('run', array($params));
      if ($this->useObjects()) {
        return new BackupGuardGoogle_DfareportingFile($data);
      } else {
        return $data;
      }
    }
    /**
     * Updates a report. (reports.update)
     *
     * @param string $profileId The DFA user profile ID.
     * @param string $reportId The ID of the report.
     * @param BackupGuardGoogle_Report $postBody
     * @param array $optParams Optional parameters.
     * @return BackupGuardGoogle_Report
     */
    public function update($profileId, $reportId, BackupGuardGoogle_Report $postBody, $optParams = array()) {
      $params = array('profileId' => $profileId, 'reportId' => $reportId, 'postBody' => $postBody);
      $params = array_merge($params, $optParams);
      $data = $this->__call('update', array($params));
      if ($this->useObjects()) {
        return new BackupGuardGoogle_Report($data);
      } else {
        return $data;
      }
    }
  }

  /**
   * The "compatibleFields" collection of methods.
   * Typical usage is:
   *  <code>
   *   $dfareportingService = new BackupGuardGoogle_DfareportingService(...);
   *   $compatibleFields = $dfareportingService->compatibleFields;
   *  </code>
   */
  class BackupGuardGoogle_ReportsCompatibleFieldsServiceResource extends BackupGuardGoogle_ServiceResource {

    /**
     * Returns the fields that are compatible to be selected in the respective sections of a report
     * criteria, given the fields already selected in the input report and user permissions.
     * (compatibleFields.query)
     *
     * @param string $profileId The DFA user profile ID.
     * @param BackupGuardGoogle_Report $postBody
     * @param array $optParams Optional parameters.
     * @return BackupGuardGoogle_CompatibleFields
     */
    public function query($profileId, BackupGuardGoogle_Report $postBody, $optParams = array()) {
      $params = array('profileId' => $profileId, 'postBody' => $postBody);
      $params = array_merge($params, $optParams);
      $data = $this->__call('query', array($params));
      if ($this->useObjects()) {
        return new BackupGuardGoogle_CompatibleFields($data);
      } else {
        return $data;
      }
    }
  }
  /**
   * The "files" collection of methods.
   * Typical usage is:
   *  <code>
   *   $dfareportingService = new BackupGuardGoogle_DfareportingService(...);
   *   $files = $dfareportingService->files;
   *  </code>
   */
  class BackupGuardGoogle_ReportsFilesServiceResource extends BackupGuardGoogle_ServiceResource {

    /**
     * Retrieves a report file. (files.get)
     *
     * @param string $profileId The DFA profile ID.
     * @param string $reportId The ID of the report.
     * @param string $fileId The ID of the report file.
     * @param array $optParams Optional parameters.
     * @return BackupGuardGoogle_DfareportingFile
     */
    public function get($profileId, $reportId, $fileId, $optParams = array()) {
      $params = array('profileId' => $profileId, 'reportId' => $reportId, 'fileId' => $fileId);
      $params = array_merge($params, $optParams);
      $data = $this->__call('get', array($params));
      if ($this->useObjects()) {
        return new BackupGuardGoogle_DfareportingFile($data);
      } else {
        return $data;
      }
    }
    /**
     * Lists files for a report. (files.list)
     *
     * @param string $profileId The DFA profile ID.
     * @param string $reportId The ID of the parent report.
     * @param array $optParams Optional parameters.
     *
     * @opt_param int maxResults Maximum number of results to return.
     * @opt_param string pageToken The value of the nextToken from the previous result page.
     * @opt_param string sortField The field by which to sort the list.
     * @opt_param string sortOrder Order of sorted results, default is 'DESCENDING'.
     * @return BackupGuardGoogle_FileList
     */
    public function listReportsFiles($profileId, $reportId, $optParams = array()) {
      $params = array('profileId' => $profileId, 'reportId' => $reportId);
      $params = array_merge($params, $optParams);
      $data = $this->__call('list', array($params));
      if ($this->useObjects()) {
        return new BackupGuardGoogle_FileList($data);
      } else {
        return $data;
      }
    }
  }

  /**
   * The "userProfiles" collection of methods.
   * Typical usage is:
   *  <code>
   *   $dfareportingService = new BackupGuardGoogle_DfareportingService(...);
   *   $userProfiles = $dfareportingService->userProfiles;
   *  </code>
   */
  class BackupGuardGoogle_UserProfilesServiceResource extends BackupGuardGoogle_ServiceResource {

    /**
     * Gets one user profile by ID. (userProfiles.get)
     *
     * @param string $profileId The user profile ID.
     * @param array $optParams Optional parameters.
     * @return BackupGuardGoogle_UserProfile
     */
    public function get($profileId, $optParams = array()) {
      $params = array('profileId' => $profileId);
      $params = array_merge($params, $optParams);
      $data = $this->__call('get', array($params));
      if ($this->useObjects()) {
        return new BackupGuardGoogle_UserProfile($data);
      } else {
        return $data;
      }
    }
    /**
     * Retrieves list of user profiles for a user. (userProfiles.list)
     *
     * @param array $optParams Optional parameters.
     * @return BackupGuardGoogle_UserProfileList
     */
    public function listUserProfiles($optParams = array()) {
      $params = array();
      $params = array_merge($params, $optParams);
      $data = $this->__call('list', array($params));
      if ($this->useObjects()) {
        return new BackupGuardGoogle_UserProfileList($data);
      } else {
        return $data;
      }
    }
  }

/**
 * Service definition for BackupGuardGoogle_Dfareporting (v1.3).
 *
 * <p>
 * Lets you create, run and download reports.
 * </p>
 *
 * <p>
 * For more information about this service, see the
 * <a href="https://developers.google.com/doubleclick-advertisers/reporting/" target="_blank">API Documentation</a>
 * </p>
 *
 * @author Google, Inc.
 */
class BackupGuardGoogle_DfareportingService extends BackupGuardGoogle_Service {
  public $dimensionValues;
  public $files;
  public $reports;
  public $reports_compatibleFields;
  public $reports_files;
  public $userProfiles;
  /**
   * Constructs the internal representation of the Dfareporting service.
   *
   * @param BackupGuardGoogle_Client $client
   */
  public function __construct(BackupGuardGoogle_Client $client) {
    $this->servicePath = 'dfareporting/v1.3/';
    $this->version = 'v1.3';
    $this->serviceName = 'dfareporting';

    $client->addService($this->serviceName, $this->version);
    $this->dimensionValues = new BackupGuardGoogle_DimensionValuesServiceResource($this, $this->serviceName, 'dimensionValues', json_decode('{"methods": {"query": {"id": "dfareporting.dimensionValues.query", "path": "userprofiles/{profileId}/dimensionvalues/query", "httpMethod": "POST", "parameters": {"maxResults": {"type": "integer", "format": "int32", "minimum": "0", "maximum": "100", "location": "query"}, "pageToken": {"type": "string", "location": "query"}, "profileId": {"type": "string", "required": true, "format": "int64", "location": "path"}}, "request": {"$ref": "DimensionValueRequest"}, "response": {"$ref": "DimensionValueList"}, "scopes": ["https://www.googleapis.com/auth/dfareporting"]}}}', true));
    $this->files = new BackupGuardGoogle_FilesServiceResource($this, $this->serviceName, 'files', json_decode('{"methods": {"get": {"id": "dfareporting.files.get", "path": "reports/{reportId}/files/{fileId}", "httpMethod": "GET", "parameters": {"fileId": {"type": "string", "required": true, "format": "int64", "location": "path"}, "reportId": {"type": "string", "required": true, "format": "int64", "location": "path"}}, "response": {"$ref": "File"}, "scopes": ["https://www.googleapis.com/auth/dfareporting"], "supportsMediaDownload": true}, "list": {"id": "dfareporting.files.list", "path": "userprofiles/{profileId}/files", "httpMethod": "GET", "parameters": {"maxResults": {"type": "integer", "format": "int32", "minimum": "0", "maximum": "10", "location": "query"}, "pageToken": {"type": "string", "location": "query"}, "profileId": {"type": "string", "required": true, "format": "int64", "location": "path"}, "scope": {"type": "string", "default": "MINE", "enum": ["ALL", "MINE", "SHARED_WITH_ME"], "location": "query"}, "sortField": {"type": "string", "default": "LAST_MODIFIED_TIME", "enum": ["ID", "LAST_MODIFIED_TIME"], "location": "query"}, "sortOrder": {"type": "string", "default": "DESCENDING", "enum": ["ASCENDING", "DESCENDING"], "location": "query"}}, "response": {"$ref": "FileList"}, "scopes": ["https://www.googleapis.com/auth/dfareporting"]}}}', true));
    $this->reports = new BackupGuardGoogle_ReportsServiceResource($this, $this->serviceName, 'reports', json_decode('{"methods": {"delete": {"id": "dfareporting.reports.delete", "path": "userprofiles/{profileId}/reports/{reportId}", "httpMethod": "DELETE", "parameters": {"profileId": {"type": "string", "required": true, "format": "int64", "location": "path"}, "reportId": {"type": "string", "required": true, "format": "int64", "location": "path"}}, "scopes": ["https://www.googleapis.com/auth/dfareporting"]}, "get": {"id": "dfareporting.reports.get", "path": "userprofiles/{profileId}/reports/{reportId}", "httpMethod": "GET", "parameters": {"profileId": {"type": "string", "required": true, "format": "int64", "location": "path"}, "reportId": {"type": "string", "required": true, "format": "int64", "location": "path"}}, "response": {"$ref": "Report"}, "scopes": ["https://www.googleapis.com/auth/dfareporting"]}, "insert": {"id": "dfareporting.reports.insert", "path": "userprofiles/{profileId}/reports", "httpMethod": "POST", "parameters": {"profileId": {"type": "string", "required": true, "format": "int64", "location": "path"}}, "request": {"$ref": "Report"}, "response": {"$ref": "Report"}, "scopes": ["https://www.googleapis.com/auth/dfareporting"]}, "list": {"id": "dfareporting.reports.list", "path": "userprofiles/{profileId}/reports", "httpMethod": "GET", "parameters": {"maxResults": {"type": "integer", "format": "int32", "minimum": "0", "maximum": "10", "location": "query"}, "pageToken": {"type": "string", "location": "query"}, "profileId": {"type": "string", "required": true, "format": "int64", "location": "path"}, "scope": {"type": "string", "default": "MINE", "enum": ["ALL", "MINE"], "location": "query"}, "sortField": {"type": "string", "default": "LAST_MODIFIED_TIME", "enum": ["ID", "LAST_MODIFIED_TIME", "NAME"], "location": "query"}, "sortOrder": {"type": "string", "default": "DESCENDING", "enum": ["ASCENDING", "DESCENDING"], "location": "query"}}, "response": {"$ref": "ReportList"}, "scopes": ["https://www.googleapis.com/auth/dfareporting"]}, "patch": {"id": "dfareporting.reports.patch", "path": "userprofiles/{profileId}/reports/{reportId}", "httpMethod": "PATCH", "parameters": {"profileId": {"type": "string", "required": true, "format": "int64", "location": "path"}, "reportId": {"type": "string", "required": true, "format": "int64", "location": "path"}}, "request": {"$ref": "Report"}, "response": {"$ref": "Report"}, "scopes": ["https://www.googleapis.com/auth/dfareporting"]}, "run": {"id": "dfareporting.reports.run", "path": "userprofiles/{profileId}/reports/{reportId}/run", "httpMethod": "POST", "parameters": {"profileId": {"type": "string", "required": true, "format": "int64", "location": "path"}, "reportId": {"type": "string", "required": true, "format": "int64", "location": "path"}, "synchronous": {"type": "boolean", "location": "query"}}, "response": {"$ref": "File"}, "scopes": ["https://www.googleapis.com/auth/dfareporting"]}, "update": {"id": "dfareporting.reports.update", "path": "userprofiles/{profileId}/reports/{reportId}", "httpMethod": "PUT", "parameters": {"profileId": {"type": "string", "required": true, "format": "int64", "location": "path"}, "reportId": {"type": "string", "required": true, "format": "int64", "location": "path"}}, "request": {"$ref": "Report"}, "response": {"$ref": "Report"}, "scopes": ["https://www.googleapis.com/auth/dfareporting"]}}}', true));
    $this->reports_compatibleFields = new BackupGuardGoogle_ReportsCompatibleFieldsServiceResource($this, $this->serviceName, 'compatibleFields', json_decode('{"methods": {"query": {"id": "dfareporting.reports.compatibleFields.query", "path": "userprofiles/{profileId}/reports/compatiblefields/query", "httpMethod": "POST", "parameters": {"profileId": {"type": "string", "required": true, "format": "int64", "location": "path"}}, "request": {"$ref": "Report"}, "response": {"$ref": "CompatibleFields"}, "scopes": ["https://www.googleapis.com/auth/dfareporting"]}}}', true));
    $this->reports_files = new BackupGuardGoogle_ReportsFilesServiceResource($this, $this->serviceName, 'files', json_decode('{"methods": {"get": {"id": "dfareporting.reports.files.get", "path": "userprofiles/{profileId}/reports/{reportId}/files/{fileId}", "httpMethod": "GET", "parameters": {"fileId": {"type": "string", "required": true, "format": "int64", "location": "path"}, "profileId": {"type": "string", "required": true, "format": "int64", "location": "path"}, "reportId": {"type": "string", "required": true, "format": "int64", "location": "path"}}, "response": {"$ref": "File"}, "scopes": ["https://www.googleapis.com/auth/dfareporting"], "supportsMediaDownload": true}, "list": {"id": "dfareporting.reports.files.list", "path": "userprofiles/{profileId}/reports/{reportId}/files", "httpMethod": "GET", "parameters": {"maxResults": {"type": "integer", "format": "int32", "minimum": "0", "maximum": "10", "location": "query"}, "pageToken": {"type": "string", "location": "query"}, "profileId": {"type": "string", "required": true, "format": "int64", "location": "path"}, "reportId": {"type": "string", "required": true, "format": "int64", "location": "path"}, "sortField": {"type": "string", "default": "LAST_MODIFIED_TIME", "enum": ["ID", "LAST_MODIFIED_TIME"], "location": "query"}, "sortOrder": {"type": "string", "default": "DESCENDING", "enum": ["ASCENDING", "DESCENDING"], "location": "query"}}, "response": {"$ref": "FileList"}, "scopes": ["https://www.googleapis.com/auth/dfareporting"]}}}', true));
    $this->userProfiles = new BackupGuardGoogle_UserProfilesServiceResource($this, $this->serviceName, 'userProfiles', json_decode('{"methods": {"get": {"id": "dfareporting.userProfiles.get", "path": "userprofiles/{profileId}", "httpMethod": "GET", "parameters": {"profileId": {"type": "string", "required": true, "format": "int64", "location": "path"}}, "response": {"$ref": "UserProfile"}, "scopes": ["https://www.googleapis.com/auth/dfareporting"]}, "list": {"id": "dfareporting.userProfiles.list", "path": "userprofiles", "httpMethod": "GET", "response": {"$ref": "UserProfileList"}, "scopes": ["https://www.googleapis.com/auth/dfareporting"]}}}', true));

  }
}



class BackupGuardGoogle_Activities extends BackupGuardGoogle_Model {
  protected $__filtersType = 'BackupGuardGoogle_DimensionValue';
  protected $__filtersDataType = 'array';
  public $filters;
  public $kind;
  public $metricNames;
  public function setFilters(/* array(BackupGuardGoogle_DimensionValue) */ $filters) {
    $this->assertIsArray($filters, 'BackupGuardGoogle_DimensionValue', __METHOD__);
    $this->filters = $filters;
  }
  public function getFilters() {
    return $this->filters;
  }
  public function setKind( $kind) {
    $this->kind = $kind;
  }
  public function getKind() {
    return $this->kind;
  }
  public function setMetricNames(/* array(BackupGuardGoogle_string) */ $metricNames) {
    $this->assertIsArray($metricNames, 'BackupGuardGoogle_string', __METHOD__);
    $this->metricNames = $metricNames;
  }
  public function getMetricNames() {
    return $this->metricNames;
  }
}

class BackupGuardGoogle_CompatibleFields extends BackupGuardGoogle_Model {
  protected $__crossDimensionReachReportCompatibleFieldsType = 'BackupGuardGoogle_CrossDimensionReachReportCompatibleFields';
  protected $__crossDimensionReachReportCompatibleFieldsDataType = '';
  public $crossDimensionReachReportCompatibleFields;
  protected $__floodlightReportCompatibleFieldsType = 'BackupGuardGoogle_FloodlightReportCompatibleFields';
  protected $__floodlightReportCompatibleFieldsDataType = '';
  public $floodlightReportCompatibleFields;
  public $kind;
  protected $__pathToConversionReportCompatibleFieldsType = 'BackupGuardGoogle_PathToConversionReportCompatibleFields';
  protected $__pathToConversionReportCompatibleFieldsDataType = '';
  public $pathToConversionReportCompatibleFields;
  protected $__reachReportCompatibleFieldsType = 'BackupGuardGoogle_ReachReportCompatibleFields';
  protected $__reachReportCompatibleFieldsDataType = '';
  public $reachReportCompatibleFields;
  protected $__reportCompatibleFieldsType = 'BackupGuardGoogle_ReportCompatibleFields';
  protected $__reportCompatibleFieldsDataType = '';
  public $reportCompatibleFields;
  public function setCrossDimensionReachReportCompatibleFields(BackupGuardGoogle_CrossDimensionReachReportCompatibleFields $crossDimensionReachReportCompatibleFields) {
    $this->crossDimensionReachReportCompatibleFields = $crossDimensionReachReportCompatibleFields;
  }
  public function getCrossDimensionReachReportCompatibleFields() {
    return $this->crossDimensionReachReportCompatibleFields;
  }
  public function setFloodlightReportCompatibleFields(BackupGuardGoogle_FloodlightReportCompatibleFields $floodlightReportCompatibleFields) {
    $this->floodlightReportCompatibleFields = $floodlightReportCompatibleFields;
  }
  public function getFloodlightReportCompatibleFields() {
    return $this->floodlightReportCompatibleFields;
  }
  public function setKind( $kind) {
    $this->kind = $kind;
  }
  public function getKind() {
    return $this->kind;
  }
  public function setPathToConversionReportCompatibleFields(BackupGuardGoogle_PathToConversionReportCompatibleFields $pathToConversionReportCompatibleFields) {
    $this->pathToConversionReportCompatibleFields = $pathToConversionReportCompatibleFields;
  }
  public function getPathToConversionReportCompatibleFields() {
    return $this->pathToConversionReportCompatibleFields;
  }
  public function setReachReportCompatibleFields(BackupGuardGoogle_ReachReportCompatibleFields $reachReportCompatibleFields) {
    $this->reachReportCompatibleFields = $reachReportCompatibleFields;
  }
  public function getReachReportCompatibleFields() {
    return $this->reachReportCompatibleFields;
  }
  public function setReportCompatibleFields(BackupGuardGoogle_ReportCompatibleFields $reportCompatibleFields) {
    $this->reportCompatibleFields = $reportCompatibleFields;
  }
  public function getReportCompatibleFields() {
    return $this->reportCompatibleFields;
  }
}

class BackupGuardGoogle_CrossDimensionReachReportCompatibleFields extends BackupGuardGoogle_Model {
  protected $__breakdownType = 'BackupGuardGoogle_Dimension';
  protected $__breakdownDataType = 'array';
  public $breakdown;
  protected $__dimensionFiltersType = 'BackupGuardGoogle_Dimension';
  protected $__dimensionFiltersDataType = 'array';
  public $dimensionFilters;
  public $kind;
  protected $__metricsType = 'BackupGuardGoogle_Metric';
  protected $__metricsDataType = 'array';
  public $metrics;
  protected $__overlapMetricsType = 'BackupGuardGoogle_Metric';
  protected $__overlapMetricsDataType = 'array';
  public $overlapMetrics;
  public function setBreakdown(/* array(BackupGuardGoogle_Dimension) */ $breakdown) {
    $this->assertIsArray($breakdown, 'BackupGuardGoogle_Dimension', __METHOD__);
    $this->breakdown = $breakdown;
  }
  public function getBreakdown() {
    return $this->breakdown;
  }
  public function setDimensionFilters(/* array(BackupGuardGoogle_Dimension) */ $dimensionFilters) {
    $this->assertIsArray($dimensionFilters, 'BackupGuardGoogle_Dimension', __METHOD__);
    $this->dimensionFilters = $dimensionFilters;
  }
  public function getDimensionFilters() {
    return $this->dimensionFilters;
  }
  public function setKind( $kind) {
    $this->kind = $kind;
  }
  public function getKind() {
    return $this->kind;
  }
  public function setMetrics(/* array(BackupGuardGoogle_Metric) */ $metrics) {
    $this->assertIsArray($metrics, 'BackupGuardGoogle_Metric', __METHOD__);
    $this->metrics = $metrics;
  }
  public function getMetrics() {
    return $this->metrics;
  }
  public function setOverlapMetrics(/* array(BackupGuardGoogle_Metric) */ $overlapMetrics) {
    $this->assertIsArray($overlapMetrics, 'BackupGuardGoogle_Metric', __METHOD__);
    $this->overlapMetrics = $overlapMetrics;
  }
  public function getOverlapMetrics() {
    return $this->overlapMetrics;
  }
}

class BackupGuardGoogle_CustomRichMediaEvents extends BackupGuardGoogle_Model {
  protected $__filteredEventIdsType = 'BackupGuardGoogle_DimensionValue';
  protected $__filteredEventIdsDataType = 'array';
  public $filteredEventIds;
  public $kind;
  public function setFilteredEventIds(/* array(BackupGuardGoogle_DimensionValue) */ $filteredEventIds) {
    $this->assertIsArray($filteredEventIds, 'BackupGuardGoogle_DimensionValue', __METHOD__);
    $this->filteredEventIds = $filteredEventIds;
  }
  public function getFilteredEventIds() {
    return $this->filteredEventIds;
  }
  public function setKind( $kind) {
    $this->kind = $kind;
  }
  public function getKind() {
    return $this->kind;
  }
}

class BackupGuardGoogle_DateRange extends BackupGuardGoogle_Model {
  public $endDate;
  public $kind;
  public $relativeDateRange;
  public $startDate;
  public function setEndDate( $endDate) {
    $this->endDate = $endDate;
  }
  public function getEndDate() {
    return $this->endDate;
  }
  public function setKind( $kind) {
    $this->kind = $kind;
  }
  public function getKind() {
    return $this->kind;
  }
  public function setRelativeDateRange( $relativeDateRange) {
    $this->relativeDateRange = $relativeDateRange;
  }
  public function getRelativeDateRange() {
    return $this->relativeDateRange;
  }
  public function setStartDate( $startDate) {
    $this->startDate = $startDate;
  }
  public function getStartDate() {
    return $this->startDate;
  }
}

class BackupGuardGoogle_DfareportingFile extends BackupGuardGoogle_Model {
  protected $__dateRangeType = 'BackupGuardGoogle_DateRange';
  protected $__dateRangeDataType = '';
  public $dateRange;
  public $etag;
  public $fileName;
  public $format;
  public $id;
  public $kind;
  public $lastModifiedTime;
  public $reportId;
  public $status;
  protected $__urlsType = 'BackupGuardGoogle_DfareportingFileUrls';
  protected $__urlsDataType = '';
  public $urls;
  public function setDateRange(BackupGuardGoogle_DateRange $dateRange) {
    $this->dateRange = $dateRange;
  }
  public function getDateRange() {
    return $this->dateRange;
  }
  public function setEtag( $etag) {
    $this->etag = $etag;
  }
  public function getEtag() {
    return $this->etag;
  }
  public function setFileName( $fileName) {
    $this->fileName = $fileName;
  }
  public function getFileName() {
    return $this->fileName;
  }
  public function setFormat( $format) {
    $this->format = $format;
  }
  public function getFormat() {
    return $this->format;
  }
  public function setId( $id) {
    $this->id = $id;
  }
  public function getId() {
    return $this->id;
  }
  public function setKind( $kind) {
    $this->kind = $kind;
  }
  public function getKind() {
    return $this->kind;
  }
  public function setLastModifiedTime( $lastModifiedTime) {
    $this->lastModifiedTime = $lastModifiedTime;
  }
  public function getLastModifiedTime() {
    return $this->lastModifiedTime;
  }
  public function setReportId( $reportId) {
    $this->reportId = $reportId;
  }
  public function getReportId() {
    return $this->reportId;
  }
  public function setStatus( $status) {
    $this->status = $status;
  }
  public function getStatus() {
    return $this->status;
  }
  public function setUrls(BackupGuardGoogle_DfareportingFileUrls $urls) {
    $this->urls = $urls;
  }
  public function getUrls() {
    return $this->urls;
  }
}

class BackupGuardGoogle_DfareportingFileUrls extends BackupGuardGoogle_Model {
  public $apiUrl;
  public $browserUrl;
  public function setApiUrl( $apiUrl) {
    $this->apiUrl = $apiUrl;
  }
  public function getApiUrl() {
    return $this->apiUrl;
  }
  public function setBrowserUrl( $browserUrl) {
    $this->browserUrl = $browserUrl;
  }
  public function getBrowserUrl() {
    return $this->browserUrl;
  }
}

class BackupGuardGoogle_Dimension extends BackupGuardGoogle_Model {
  public $kind;
  public $name;
  public function setKind( $kind) {
    $this->kind = $kind;
  }
  public function getKind() {
    return $this->kind;
  }
  public function setName( $name) {
    $this->name = $name;
  }
  public function getName() {
    return $this->name;
  }
}

class BackupGuardGoogle_DimensionFilter extends BackupGuardGoogle_Model {
  public $dimensionName;
  public $kind;
  public $value;
  public function setDimensionName( $dimensionName) {
    $this->dimensionName = $dimensionName;
  }
  public function getDimensionName() {
    return $this->dimensionName;
  }
  public function setKind( $kind) {
    $this->kind = $kind;
  }
  public function getKind() {
    return $this->kind;
  }
  public function setValue( $value) {
    $this->value = $value;
  }
  public function getValue() {
    return $this->value;
  }
}

class BackupGuardGoogle_DimensionValue extends BackupGuardGoogle_Model {
  public $dimensionName;
  public $etag;
  public $id;
  public $kind;
  public $matchType;
  public $value;
  public function setDimensionName( $dimensionName) {
    $this->dimensionName = $dimensionName;
  }
  public function getDimensionName() {
    return $this->dimensionName;
  }
  public function setEtag( $etag) {
    $this->etag = $etag;
  }
  public function getEtag() {
    return $this->etag;
  }
  public function setId( $id) {
    $this->id = $id;
  }
  public function getId() {
    return $this->id;
  }
  public function setKind( $kind) {
    $this->kind = $kind;
  }
  public function getKind() {
    return $this->kind;
  }
  public function setMatchType( $matchType) {
    $this->matchType = $matchType;
  }
  public function getMatchType() {
    return $this->matchType;
  }
  public function setValue( $value) {
    $this->value = $value;
  }
  public function getValue() {
    return $this->value;
  }
}

class BackupGuardGoogle_DimensionValueList extends BackupGuardGoogle_Model {
  public $etag;
  protected $__itemsType = 'BackupGuardGoogle_DimensionValue';
  protected $__itemsDataType = 'array';
  public $items;
  public $kind;
  public $nextPageToken;
  public function setEtag( $etag) {
    $this->etag = $etag;
  }
  public function getEtag() {
    return $this->etag;
  }
  public function setItems(/* array(BackupGuardGoogle_DimensionValue) */ $items) {
    $this->assertIsArray($items, 'BackupGuardGoogle_DimensionValue', __METHOD__);
    $this->items = $items;
  }
  public function getItems() {
    return $this->items;
  }
  public function setKind( $kind) {
    $this->kind = $kind;
  }
  public function getKind() {
    return $this->kind;
  }
  public function setNextPageToken( $nextPageToken) {
    $this->nextPageToken = $nextPageToken;
  }
  public function getNextPageToken() {
    return $this->nextPageToken;
  }
}

class BackupGuardGoogle_DimensionValueRequest extends BackupGuardGoogle_Model {
  public $dimensionName;
  public $endDate;
  protected $__filtersType = 'BackupGuardGoogle_DimensionFilter';
  protected $__filtersDataType = 'array';
  public $filters;
  public $kind;
  public $startDate;
  public function setDimensionName( $dimensionName) {
    $this->dimensionName = $dimensionName;
  }
  public function getDimensionName() {
    return $this->dimensionName;
  }
  public function setEndDate( $endDate) {
    $this->endDate = $endDate;
  }
  public function getEndDate() {
    return $this->endDate;
  }
  public function setFilters(/* array(BackupGuardGoogle_DimensionFilter) */ $filters) {
    $this->assertIsArray($filters, 'BackupGuardGoogle_DimensionFilter', __METHOD__);
    $this->filters = $filters;
  }
  public function getFilters() {
    return $this->filters;
  }
  public function setKind( $kind) {
    $this->kind = $kind;
  }
  public function getKind() {
    return $this->kind;
  }
  public function setStartDate( $startDate) {
    $this->startDate = $startDate;
  }
  public function getStartDate() {
    return $this->startDate;
  }
}

class BackupGuardGoogle_FileList extends BackupGuardGoogle_Model {
  public $etag;
  protected $__itemsType = 'BackupGuardGoogle_DfareportingFile';
  protected $__itemsDataType = 'array';
  public $items;
  public $kind;
  public $nextPageToken;
  public function setEtag( $etag) {
    $this->etag = $etag;
  }
  public function getEtag() {
    return $this->etag;
  }
  public function setItems(/* array(BackupGuardGoogle_DfareportingFile) */ $items) {
    $this->assertIsArray($items, 'BackupGuardGoogle_DfareportingFile', __METHOD__);
    $this->items = $items;
  }
  public function getItems() {
    return $this->items;
  }
  public function setKind( $kind) {
    $this->kind = $kind;
  }
  public function getKind() {
    return $this->kind;
  }
  public function setNextPageToken( $nextPageToken) {
    $this->nextPageToken = $nextPageToken;
  }
  public function getNextPageToken() {
    return $this->nextPageToken;
  }
}

class BackupGuardGoogle_FloodlightReportCompatibleFields extends BackupGuardGoogle_Model {
  protected $__dimensionFiltersType = 'BackupGuardGoogle_Dimension';
  protected $__dimensionFiltersDataType = 'array';
  public $dimensionFilters;
  protected $__dimensionsType = 'BackupGuardGoogle_Dimension';
  protected $__dimensionsDataType = 'array';
  public $dimensions;
  public $kind;
  protected $__metricsType = 'BackupGuardGoogle_Metric';
  protected $__metricsDataType = 'array';
  public $metrics;
  public function setDimensionFilters(/* array(BackupGuardGoogle_Dimension) */ $dimensionFilters) {
    $this->assertIsArray($dimensionFilters, 'BackupGuardGoogle_Dimension', __METHOD__);
    $this->dimensionFilters = $dimensionFilters;
  }
  public function getDimensionFilters() {
    return $this->dimensionFilters;
  }
  public function setDimensions(/* array(BackupGuardGoogle_Dimension) */ $dimensions) {
    $this->assertIsArray($dimensions, 'BackupGuardGoogle_Dimension', __METHOD__);
    $this->dimensions = $dimensions;
  }
  public function getDimensions() {
    return $this->dimensions;
  }
  public function setKind( $kind) {
    $this->kind = $kind;
  }
  public function getKind() {
    return $this->kind;
  }
  public function setMetrics(/* array(BackupGuardGoogle_Metric) */ $metrics) {
    $this->assertIsArray($metrics, 'BackupGuardGoogle_Metric', __METHOD__);
    $this->metrics = $metrics;
  }
  public function getMetrics() {
    return $this->metrics;
  }
}

class BackupGuardGoogle_Metric extends BackupGuardGoogle_Model {
  public $kind;
  public $name;
  public function setKind( $kind) {
    $this->kind = $kind;
  }
  public function getKind() {
    return $this->kind;
  }
  public function setName( $name) {
    $this->name = $name;
  }
  public function getName() {
    return $this->name;
  }
}

class BackupGuardGoogle_PathToConversionReportCompatibleFields extends BackupGuardGoogle_Model {
  protected $__conversionDimensionsType = 'BackupGuardGoogle_Dimension';
  protected $__conversionDimensionsDataType = 'array';
  public $conversionDimensions;
  protected $__customFloodlightVariablesType = 'BackupGuardGoogle_Dimension';
  protected $__customFloodlightVariablesDataType = 'array';
  public $customFloodlightVariables;
  public $kind;
  protected $__metricsType = 'BackupGuardGoogle_Metric';
  protected $__metricsDataType = 'array';
  public $metrics;
  protected $__perInteractionDimensionsType = 'BackupGuardGoogle_Dimension';
  protected $__perInteractionDimensionsDataType = 'array';
  public $perInteractionDimensions;
  public function setConversionDimensions(/* array(BackupGuardGoogle_Dimension) */ $conversionDimensions) {
    $this->assertIsArray($conversionDimensions, 'BackupGuardGoogle_Dimension', __METHOD__);
    $this->conversionDimensions = $conversionDimensions;
  }
  public function getConversionDimensions() {
    return $this->conversionDimensions;
  }
  public function setCustomFloodlightVariables(/* array(BackupGuardGoogle_Dimension) */ $customFloodlightVariables) {
    $this->assertIsArray($customFloodlightVariables, 'BackupGuardGoogle_Dimension', __METHOD__);
    $this->customFloodlightVariables = $customFloodlightVariables;
  }
  public function getCustomFloodlightVariables() {
    return $this->customFloodlightVariables;
  }
  public function setKind( $kind) {
    $this->kind = $kind;
  }
  public function getKind() {
    return $this->kind;
  }
  public function setMetrics(/* array(BackupGuardGoogle_Metric) */ $metrics) {
    $this->assertIsArray($metrics, 'BackupGuardGoogle_Metric', __METHOD__);
    $this->metrics = $metrics;
  }
  public function getMetrics() {
    return $this->metrics;
  }
  public function setPerInteractionDimensions(/* array(BackupGuardGoogle_Dimension) */ $perInteractionDimensions) {
    $this->assertIsArray($perInteractionDimensions, 'BackupGuardGoogle_Dimension', __METHOD__);
    $this->perInteractionDimensions = $perInteractionDimensions;
  }
  public function getPerInteractionDimensions() {
    return $this->perInteractionDimensions;
  }
}

class BackupGuardGoogle_ReachReportCompatibleFields extends BackupGuardGoogle_Model {
  protected $__dimensionFiltersType = 'BackupGuardGoogle_Dimension';
  protected $__dimensionFiltersDataType = 'array';
  public $dimensionFilters;
  protected $__dimensionsType = 'BackupGuardGoogle_Dimension';
  protected $__dimensionsDataType = 'array';
  public $dimensions;
  public $kind;
  protected $__metricsType = 'BackupGuardGoogle_Metric';
  protected $__metricsDataType = 'array';
  public $metrics;
  protected $__pivotedActivityMetricsType = 'BackupGuardGoogle_Metric';
  protected $__pivotedActivityMetricsDataType = 'array';
  public $pivotedActivityMetrics;
  protected $__reachByFrequencyMetricsType = 'BackupGuardGoogle_Metric';
  protected $__reachByFrequencyMetricsDataType = 'array';
  public $reachByFrequencyMetrics;
  public function setDimensionFilters(/* array(BackupGuardGoogle_Dimension) */ $dimensionFilters) {
    $this->assertIsArray($dimensionFilters, 'BackupGuardGoogle_Dimension', __METHOD__);
    $this->dimensionFilters = $dimensionFilters;
  }
  public function getDimensionFilters() {
    return $this->dimensionFilters;
  }
  public function setDimensions(/* array(BackupGuardGoogle_Dimension) */ $dimensions) {
    $this->assertIsArray($dimensions, 'BackupGuardGoogle_Dimension', __METHOD__);
    $this->dimensions = $dimensions;
  }
  public function getDimensions() {
    return $this->dimensions;
  }
  public function setKind( $kind) {
    $this->kind = $kind;
  }
  public function getKind() {
    return $this->kind;
  }
  public function setMetrics(/* array(BackupGuardGoogle_Metric) */ $metrics) {
    $this->assertIsArray($metrics, 'BackupGuardGoogle_Metric', __METHOD__);
    $this->metrics = $metrics;
  }
  public function getMetrics() {
    return $this->metrics;
  }
  public function setPivotedActivityMetrics(/* array(BackupGuardGoogle_Metric) */ $pivotedActivityMetrics) {
    $this->assertIsArray($pivotedActivityMetrics, 'BackupGuardGoogle_Metric', __METHOD__);
    $this->pivotedActivityMetrics = $pivotedActivityMetrics;
  }
  public function getPivotedActivityMetrics() {
    return $this->pivotedActivityMetrics;
  }
  public function setReachByFrequencyMetrics(/* array(BackupGuardGoogle_Metric) */ $reachByFrequencyMetrics) {
    $this->assertIsArray($reachByFrequencyMetrics, 'BackupGuardGoogle_Metric', __METHOD__);
    $this->reachByFrequencyMetrics = $reachByFrequencyMetrics;
  }
  public function getReachByFrequencyMetrics() {
    return $this->reachByFrequencyMetrics;
  }
}

class BackupGuardGoogle_Recipient extends BackupGuardGoogle_Model {
  public $deliveryType;
  public $email;
  public $kind;
  public function setDeliveryType( $deliveryType) {
    $this->deliveryType = $deliveryType;
  }
  public function getDeliveryType() {
    return $this->deliveryType;
  }
  public function setEmail( $email) {
    $this->email = $email;
  }
  public function getEmail() {
    return $this->email;
  }
  public function setKind( $kind) {
    $this->kind = $kind;
  }
  public function getKind() {
    return $this->kind;
  }
}

class BackupGuardGoogle_Report extends BackupGuardGoogle_Model {
  public $accountId;
  protected $__activeGrpCriteriaType = 'BackupGuardGoogle_ReportActiveGrpCriteria';
  protected $__activeGrpCriteriaDataType = '';
  public $activeGrpCriteria;
  protected $__criteriaType = 'BackupGuardGoogle_ReportCriteria';
  protected $__criteriaDataType = '';
  public $criteria;
  protected $__crossDimensionReachCriteriaType = 'BackupGuardGoogle_ReportCrossDimensionReachCriteria';
  protected $__crossDimensionReachCriteriaDataType = '';
  public $crossDimensionReachCriteria;
  protected $__deliveryType = 'BackupGuardGoogle_ReportDelivery';
  protected $__deliveryDataType = '';
  public $delivery;
  public $etag;
  public $fileName;
  protected $__floodlightCriteriaType = 'BackupGuardGoogle_ReportFloodlightCriteria';
  protected $__floodlightCriteriaDataType = '';
  public $floodlightCriteria;
  public $format;
  public $id;
  public $kind;
  public $lastModifiedTime;
  public $name;
  public $ownerProfileId;
  protected $__pathToConversionCriteriaType = 'BackupGuardGoogle_ReportPathToConversionCriteria';
  protected $__pathToConversionCriteriaDataType = '';
  public $pathToConversionCriteria;
  protected $__reachCriteriaType = 'BackupGuardGoogle_ReportReachCriteria';
  protected $__reachCriteriaDataType = '';
  public $reachCriteria;
  protected $__scheduleType = 'BackupGuardGoogle_ReportSchedule';
  protected $__scheduleDataType = '';
  public $schedule;
  public $subAccountId;
  public $type;
  public function setAccountId( $accountId) {
    $this->accountId = $accountId;
  }
  public function getAccountId() {
    return $this->accountId;
  }
  public function setActiveGrpCriteria(BackupGuardGoogle_ReportActiveGrpCriteria $activeGrpCriteria) {
    $this->activeGrpCriteria = $activeGrpCriteria;
  }
  public function getActiveGrpCriteria() {
    return $this->activeGrpCriteria;
  }
  public function setCriteria(BackupGuardGoogle_ReportCriteria $criteria) {
    $this->criteria = $criteria;
  }
  public function getCriteria() {
    return $this->criteria;
  }
  public function setCrossDimensionReachCriteria(BackupGuardGoogle_ReportCrossDimensionReachCriteria $crossDimensionReachCriteria) {
    $this->crossDimensionReachCriteria = $crossDimensionReachCriteria;
  }
  public function getCrossDimensionReachCriteria() {
    return $this->crossDimensionReachCriteria;
  }
  public function setDelivery(BackupGuardGoogle_ReportDelivery $delivery) {
    $this->delivery = $delivery;
  }
  public function getDelivery() {
    return $this->delivery;
  }
  public function setEtag( $etag) {
    $this->etag = $etag;
  }
  public function getEtag() {
    return $this->etag;
  }
  public function setFileName( $fileName) {
    $this->fileName = $fileName;
  }
  public function getFileName() {
    return $this->fileName;
  }
  public function setFloodlightCriteria(BackupGuardGoogle_ReportFloodlightCriteria $floodlightCriteria) {
    $this->floodlightCriteria = $floodlightCriteria;
  }
  public function getFloodlightCriteria() {
    return $this->floodlightCriteria;
  }
  public function setFormat( $format) {
    $this->format = $format;
  }
  public function getFormat() {
    return $this->format;
  }
  public function setId( $id) {
    $this->id = $id;
  }
  public function getId() {
    return $this->id;
  }
  public function setKind( $kind) {
    $this->kind = $kind;
  }
  public function getKind() {
    return $this->kind;
  }
  public function setLastModifiedTime( $lastModifiedTime) {
    $this->lastModifiedTime = $lastModifiedTime;
  }
  public function getLastModifiedTime() {
    return $this->lastModifiedTime;
  }
  public function setName( $name) {
    $this->name = $name;
  }
  public function getName() {
    return $this->name;
  }
  public function setOwnerProfileId( $ownerProfileId) {
    $this->ownerProfileId = $ownerProfileId;
  }
  public function getOwnerProfileId() {
    return $this->ownerProfileId;
  }
  public function setPathToConversionCriteria(BackupGuardGoogle_ReportPathToConversionCriteria $pathToConversionCriteria) {
    $this->pathToConversionCriteria = $pathToConversionCriteria;
  }
  public function getPathToConversionCriteria() {
    return $this->pathToConversionCriteria;
  }
  public function setReachCriteria(BackupGuardGoogle_ReportReachCriteria $reachCriteria) {
    $this->reachCriteria = $reachCriteria;
  }
  public function getReachCriteria() {
    return $this->reachCriteria;
  }
  public function setSchedule(BackupGuardGoogle_ReportSchedule $schedule) {
    $this->schedule = $schedule;
  }
  public function getSchedule() {
    return $this->schedule;
  }
  public function setSubAccountId( $subAccountId) {
    $this->subAccountId = $subAccountId;
  }
  public function getSubAccountId() {
    return $this->subAccountId;
  }
  public function setType( $type) {
    $this->type = $type;
  }
  public function getType() {
    return $this->type;
  }
}

class BackupGuardGoogle_ReportActiveGrpCriteria extends BackupGuardGoogle_Model {
  protected $__dateRangeType = 'BackupGuardGoogle_DateRange';
  protected $__dateRangeDataType = '';
  public $dateRange;
  protected $__dimensionFiltersType = 'BackupGuardGoogle_DimensionValue';
  protected $__dimensionFiltersDataType = 'array';
  public $dimensionFilters;
  protected $__dimensionsType = 'BackupGuardGoogle_SortedDimension';
  protected $__dimensionsDataType = 'array';
  public $dimensions;
  public $metricNames;
  public function setDateRange(BackupGuardGoogle_DateRange $dateRange) {
    $this->dateRange = $dateRange;
  }
  public function getDateRange() {
    return $this->dateRange;
  }
  public function setDimensionFilters(/* array(BackupGuardGoogle_DimensionValue) */ $dimensionFilters) {
    $this->assertIsArray($dimensionFilters, 'BackupGuardGoogle_DimensionValue', __METHOD__);
    $this->dimensionFilters = $dimensionFilters;
  }
  public function getDimensionFilters() {
    return $this->dimensionFilters;
  }
  public function setDimensions(/* array(BackupGuardGoogle_SortedDimension) */ $dimensions) {
    $this->assertIsArray($dimensions, 'BackupGuardGoogle_SortedDimension', __METHOD__);
    $this->dimensions = $dimensions;
  }
  public function getDimensions() {
    return $this->dimensions;
  }
  public function setMetricNames(/* array(BackupGuardGoogle_string) */ $metricNames) {
    $this->assertIsArray($metricNames, 'BackupGuardGoogle_string', __METHOD__);
    $this->metricNames = $metricNames;
  }
  public function getMetricNames() {
    return $this->metricNames;
  }
}

class BackupGuardGoogle_ReportCompatibleFields extends BackupGuardGoogle_Model {
  protected $__dimensionFiltersType = 'BackupGuardGoogle_Dimension';
  protected $__dimensionFiltersDataType = 'array';
  public $dimensionFilters;
  protected $__dimensionsType = 'BackupGuardGoogle_Dimension';
  protected $__dimensionsDataType = 'array';
  public $dimensions;
  public $kind;
  protected $__metricsType = 'BackupGuardGoogle_Metric';
  protected $__metricsDataType = 'array';
  public $metrics;
  protected $__pivotedActivityMetricsType = 'BackupGuardGoogle_Metric';
  protected $__pivotedActivityMetricsDataType = 'array';
  public $pivotedActivityMetrics;
  public function setDimensionFilters(/* array(BackupGuardGoogle_Dimension) */ $dimensionFilters) {
    $this->assertIsArray($dimensionFilters, 'BackupGuardGoogle_Dimension', __METHOD__);
    $this->dimensionFilters = $dimensionFilters;
  }
  public function getDimensionFilters() {
    return $this->dimensionFilters;
  }
  public function setDimensions(/* array(BackupGuardGoogle_Dimension) */ $dimensions) {
    $this->assertIsArray($dimensions, 'BackupGuardGoogle_Dimension', __METHOD__);
    $this->dimensions = $dimensions;
  }
  public function getDimensions() {
    return $this->dimensions;
  }
  public function setKind( $kind) {
    $this->kind = $kind;
  }
  public function getKind() {
    return $this->kind;
  }
  public function setMetrics(/* array(BackupGuardGoogle_Metric) */ $metrics) {
    $this->assertIsArray($metrics, 'BackupGuardGoogle_Metric', __METHOD__);
    $this->metrics = $metrics;
  }
  public function getMetrics() {
    return $this->metrics;
  }
  public function setPivotedActivityMetrics(/* array(BackupGuardGoogle_Metric) */ $pivotedActivityMetrics) {
    $this->assertIsArray($pivotedActivityMetrics, 'BackupGuardGoogle_Metric', __METHOD__);
    $this->pivotedActivityMetrics = $pivotedActivityMetrics;
  }
  public function getPivotedActivityMetrics() {
    return $this->pivotedActivityMetrics;
  }
}

class BackupGuardGoogle_ReportCriteria extends BackupGuardGoogle_Model {
  protected $__activitiesType = 'BackupGuardGoogle_Activities';
  protected $__activitiesDataType = '';
  public $activities;
  protected $__customRichMediaEventsType = 'BackupGuardGoogle_CustomRichMediaEvents';
  protected $__customRichMediaEventsDataType = '';
  public $customRichMediaEvents;
  protected $__dateRangeType = 'BackupGuardGoogle_DateRange';
  protected $__dateRangeDataType = '';
  public $dateRange;
  protected $__dimensionFiltersType = 'BackupGuardGoogle_DimensionValue';
  protected $__dimensionFiltersDataType = 'array';
  public $dimensionFilters;
  protected $__dimensionsType = 'BackupGuardGoogle_SortedDimension';
  protected $__dimensionsDataType = 'array';
  public $dimensions;
  public $metricNames;
  public function setActivities(BackupGuardGoogle_Activities $activities) {
    $this->activities = $activities;
  }
  public function getActivities() {
    return $this->activities;
  }
  public function setCustomRichMediaEvents(BackupGuardGoogle_CustomRichMediaEvents $customRichMediaEvents) {
    $this->customRichMediaEvents = $customRichMediaEvents;
  }
  public function getCustomRichMediaEvents() {
    return $this->customRichMediaEvents;
  }
  public function setDateRange(BackupGuardGoogle_DateRange $dateRange) {
    $this->dateRange = $dateRange;
  }
  public function getDateRange() {
    return $this->dateRange;
  }
  public function setDimensionFilters(/* array(BackupGuardGoogle_DimensionValue) */ $dimensionFilters) {
    $this->assertIsArray($dimensionFilters, 'BackupGuardGoogle_DimensionValue', __METHOD__);
    $this->dimensionFilters = $dimensionFilters;
  }
  public function getDimensionFilters() {
    return $this->dimensionFilters;
  }
  public function setDimensions(/* array(BackupGuardGoogle_SortedDimension) */ $dimensions) {
    $this->assertIsArray($dimensions, 'BackupGuardGoogle_SortedDimension', __METHOD__);
    $this->dimensions = $dimensions;
  }
  public function getDimensions() {
    return $this->dimensions;
  }
  public function setMetricNames(/* array(BackupGuardGoogle_string) */ $metricNames) {
    $this->assertIsArray($metricNames, 'BackupGuardGoogle_string', __METHOD__);
    $this->metricNames = $metricNames;
  }
  public function getMetricNames() {
    return $this->metricNames;
  }
}

class BackupGuardGoogle_ReportCrossDimensionReachCriteria extends BackupGuardGoogle_Model {
  protected $__breakdownType = 'BackupGuardGoogle_SortedDimension';
  protected $__breakdownDataType = 'array';
  public $breakdown;
  protected $__dateRangeType = 'BackupGuardGoogle_DateRange';
  protected $__dateRangeDataType = '';
  public $dateRange;
  public $dimension;
  protected $__dimensionFiltersType = 'BackupGuardGoogle_DimensionValue';
  protected $__dimensionFiltersDataType = 'array';
  public $dimensionFilters;
  public $metricNames;
  public $overlapMetricNames;
  public $pivoted;
  public function setBreakdown(/* array(BackupGuardGoogle_SortedDimension) */ $breakdown) {
    $this->assertIsArray($breakdown, 'BackupGuardGoogle_SortedDimension', __METHOD__);
    $this->breakdown = $breakdown;
  }
  public function getBreakdown() {
    return $this->breakdown;
  }
  public function setDateRange(BackupGuardGoogle_DateRange $dateRange) {
    $this->dateRange = $dateRange;
  }
  public function getDateRange() {
    return $this->dateRange;
  }
  public function setDimension( $dimension) {
    $this->dimension = $dimension;
  }
  public function getDimension() {
    return $this->dimension;
  }
  public function setDimensionFilters(/* array(BackupGuardGoogle_DimensionValue) */ $dimensionFilters) {
    $this->assertIsArray($dimensionFilters, 'BackupGuardGoogle_DimensionValue', __METHOD__);
    $this->dimensionFilters = $dimensionFilters;
  }
  public function getDimensionFilters() {
    return $this->dimensionFilters;
  }
  public function setMetricNames(/* array(BackupGuardGoogle_string) */ $metricNames) {
    $this->assertIsArray($metricNames, 'BackupGuardGoogle_string', __METHOD__);
    $this->metricNames = $metricNames;
  }
  public function getMetricNames() {
    return $this->metricNames;
  }
  public function setOverlapMetricNames(/* array(BackupGuardGoogle_string) */ $overlapMetricNames) {
    $this->assertIsArray($overlapMetricNames, 'BackupGuardGoogle_string', __METHOD__);
    $this->overlapMetricNames = $overlapMetricNames;
  }
  public function getOverlapMetricNames() {
    return $this->overlapMetricNames;
  }
  public function setPivoted( $pivoted) {
    $this->pivoted = $pivoted;
  }
  public function getPivoted() {
    return $this->pivoted;
  }
}

class BackupGuardGoogle_ReportDelivery extends BackupGuardGoogle_Model {
  public $emailOwner;
  public $emailOwnerDeliveryType;
  public $message;
  protected $__recipientsType = 'BackupGuardGoogle_Recipient';
  protected $__recipientsDataType = 'array';
  public $recipients;
  public function setEmailOwner( $emailOwner) {
    $this->emailOwner = $emailOwner;
  }
  public function getEmailOwner() {
    return $this->emailOwner;
  }
  public function setEmailOwnerDeliveryType( $emailOwnerDeliveryType) {
    $this->emailOwnerDeliveryType = $emailOwnerDeliveryType;
  }
  public function getEmailOwnerDeliveryType() {
    return $this->emailOwnerDeliveryType;
  }
  public function setMessage( $message) {
    $this->message = $message;
  }
  public function getMessage() {
    return $this->message;
  }
  public function setRecipients(/* array(BackupGuardGoogle_Recipient) */ $recipients) {
    $this->assertIsArray($recipients, 'BackupGuardGoogle_Recipient', __METHOD__);
    $this->recipients = $recipients;
  }
  public function getRecipients() {
    return $this->recipients;
  }
}

class BackupGuardGoogle_ReportFloodlightCriteria extends BackupGuardGoogle_Model {
  protected $__customRichMediaEventsType = 'BackupGuardGoogle_DimensionValue';
  protected $__customRichMediaEventsDataType = 'array';
  public $customRichMediaEvents;
  protected $__dateRangeType = 'BackupGuardGoogle_DateRange';
  protected $__dateRangeDataType = '';
  public $dateRange;
  protected $__dimensionFiltersType = 'BackupGuardGoogle_DimensionValue';
  protected $__dimensionFiltersDataType = 'array';
  public $dimensionFilters;
  protected $__dimensionsType = 'BackupGuardGoogle_SortedDimension';
  protected $__dimensionsDataType = 'array';
  public $dimensions;
  protected $__floodlightConfigIdType = 'BackupGuardGoogle_DimensionValue';
  protected $__floodlightConfigIdDataType = '';
  public $floodlightConfigId;
  public $metricNames;
  protected $__reportPropertiesType = 'BackupGuardGoogle_ReportFloodlightCriteriaReportProperties';
  protected $__reportPropertiesDataType = '';
  public $reportProperties;
  public function setCustomRichMediaEvents(/* array(BackupGuardGoogle_DimensionValue) */ $customRichMediaEvents) {
    $this->assertIsArray($customRichMediaEvents, 'BackupGuardGoogle_DimensionValue', __METHOD__);
    $this->customRichMediaEvents = $customRichMediaEvents;
  }
  public function getCustomRichMediaEvents() {
    return $this->customRichMediaEvents;
  }
  public function setDateRange(BackupGuardGoogle_DateRange $dateRange) {
    $this->dateRange = $dateRange;
  }
  public function getDateRange() {
    return $this->dateRange;
  }
  public function setDimensionFilters(/* array(BackupGuardGoogle_DimensionValue) */ $dimensionFilters) {
    $this->assertIsArray($dimensionFilters, 'BackupGuardGoogle_DimensionValue', __METHOD__);
    $this->dimensionFilters = $dimensionFilters;
  }
  public function getDimensionFilters() {
    return $this->dimensionFilters;
  }
  public function setDimensions(/* array(BackupGuardGoogle_SortedDimension) */ $dimensions) {
    $this->assertIsArray($dimensions, 'BackupGuardGoogle_SortedDimension', __METHOD__);
    $this->dimensions = $dimensions;
  }
  public function getDimensions() {
    return $this->dimensions;
  }
  public function setFloodlightConfigId(BackupGuardGoogle_DimensionValue $floodlightConfigId) {
    $this->floodlightConfigId = $floodlightConfigId;
  }
  public function getFloodlightConfigId() {
    return $this->floodlightConfigId;
  }
  public function setMetricNames(/* array(BackupGuardGoogle_string) */ $metricNames) {
    $this->assertIsArray($metricNames, 'BackupGuardGoogle_string', __METHOD__);
    $this->metricNames = $metricNames;
  }
  public function getMetricNames() {
    return $this->metricNames;
  }
  public function setReportProperties(BackupGuardGoogle_ReportFloodlightCriteriaReportProperties $reportProperties) {
    $this->reportProperties = $reportProperties;
  }
  public function getReportProperties() {
    return $this->reportProperties;
  }
}

class BackupGuardGoogle_ReportFloodlightCriteriaReportProperties extends BackupGuardGoogle_Model {
  public $includeAttributedIPConversions;
  public $includeUnattributedCookieConversions;
  public $includeUnattributedIPConversions;
  public function setIncludeAttributedIPConversions( $includeAttributedIPConversions) {
    $this->includeAttributedIPConversions = $includeAttributedIPConversions;
  }
  public function getIncludeAttributedIPConversions() {
    return $this->includeAttributedIPConversions;
  }
  public function setIncludeUnattributedCookieConversions( $includeUnattributedCookieConversions) {
    $this->includeUnattributedCookieConversions = $includeUnattributedCookieConversions;
  }
  public function getIncludeUnattributedCookieConversions() {
    return $this->includeUnattributedCookieConversions;
  }
  public function setIncludeUnattributedIPConversions( $includeUnattributedIPConversions) {
    $this->includeUnattributedIPConversions = $includeUnattributedIPConversions;
  }
  public function getIncludeUnattributedIPConversions() {
    return $this->includeUnattributedIPConversions;
  }
}

class BackupGuardGoogle_ReportList extends BackupGuardGoogle_Model {
  public $etag;
  protected $__itemsType = 'BackupGuardGoogle_Report';
  protected $__itemsDataType = 'array';
  public $items;
  public $kind;
  public $nextPageToken;
  public function setEtag( $etag) {
    $this->etag = $etag;
  }
  public function getEtag() {
    return $this->etag;
  }
  public function setItems(/* array(BackupGuardGoogle_Report) */ $items) {
    $this->assertIsArray($items, 'BackupGuardGoogle_Report', __METHOD__);
    $this->items = $items;
  }
  public function getItems() {
    return $this->items;
  }
  public function setKind( $kind) {
    $this->kind = $kind;
  }
  public function getKind() {
    return $this->kind;
  }
  public function setNextPageToken( $nextPageToken) {
    $this->nextPageToken = $nextPageToken;
  }
  public function getNextPageToken() {
    return $this->nextPageToken;
  }
}

class BackupGuardGoogle_ReportPathToConversionCriteria extends BackupGuardGoogle_Model {
  protected $__activityFiltersType = 'BackupGuardGoogle_DimensionValue';
  protected $__activityFiltersDataType = 'array';
  public $activityFilters;
  protected $__conversionDimensionsType = 'BackupGuardGoogle_SortedDimension';
  protected $__conversionDimensionsDataType = 'array';
  public $conversionDimensions;
  protected $__customFloodlightVariablesType = 'BackupGuardGoogle_SortedDimension';
  protected $__customFloodlightVariablesDataType = 'array';
  public $customFloodlightVariables;
  protected $__customRichMediaEventsType = 'BackupGuardGoogle_DimensionValue';
  protected $__customRichMediaEventsDataType = 'array';
  public $customRichMediaEvents;
  protected $__dateRangeType = 'BackupGuardGoogle_DateRange';
  protected $__dateRangeDataType = '';
  public $dateRange;
  protected $__floodlightConfigIdType = 'BackupGuardGoogle_DimensionValue';
  protected $__floodlightConfigIdDataType = '';
  public $floodlightConfigId;
  public $metricNames;
  protected $__perInteractionDimensionsType = 'BackupGuardGoogle_SortedDimension';
  protected $__perInteractionDimensionsDataType = 'array';
  public $perInteractionDimensions;
  protected $__reportPropertiesType = 'BackupGuardGoogle_ReportPathToConversionCriteriaReportProperties';
  protected $__reportPropertiesDataType = '';
  public $reportProperties;
  public function setActivityFilters(/* array(BackupGuardGoogle_DimensionValue) */ $activityFilters) {
    $this->assertIsArray($activityFilters, 'BackupGuardGoogle_DimensionValue', __METHOD__);
    $this->activityFilters = $activityFilters;
  }
  public function getActivityFilters() {
    return $this->activityFilters;
  }
  public function setConversionDimensions(/* array(BackupGuardGoogle_SortedDimension) */ $conversionDimensions) {
    $this->assertIsArray($conversionDimensions, 'BackupGuardGoogle_SortedDimension', __METHOD__);
    $this->conversionDimensions = $conversionDimensions;
  }
  public function getConversionDimensions() {
    return $this->conversionDimensions;
  }
  public function setCustomFloodlightVariables(/* array(BackupGuardGoogle_SortedDimension) */ $customFloodlightVariables) {
    $this->assertIsArray($customFloodlightVariables, 'BackupGuardGoogle_SortedDimension', __METHOD__);
    $this->customFloodlightVariables = $customFloodlightVariables;
  }
  public function getCustomFloodlightVariables() {
    return $this->customFloodlightVariables;
  }
  public function setCustomRichMediaEvents(/* array(BackupGuardGoogle_DimensionValue) */ $customRichMediaEvents) {
    $this->assertIsArray($customRichMediaEvents, 'BackupGuardGoogle_DimensionValue', __METHOD__);
    $this->customRichMediaEvents = $customRichMediaEvents;
  }
  public function getCustomRichMediaEvents() {
    return $this->customRichMediaEvents;
  }
  public function setDateRange(BackupGuardGoogle_DateRange $dateRange) {
    $this->dateRange = $dateRange;
  }
  public function getDateRange() {
    return $this->dateRange;
  }
  public function setFloodlightConfigId(BackupGuardGoogle_DimensionValue $floodlightConfigId) {
    $this->floodlightConfigId = $floodlightConfigId;
  }
  public function getFloodlightConfigId() {
    return $this->floodlightConfigId;
  }
  public function setMetricNames(/* array(BackupGuardGoogle_string) */ $metricNames) {
    $this->assertIsArray($metricNames, 'BackupGuardGoogle_string', __METHOD__);
    $this->metricNames = $metricNames;
  }
  public function getMetricNames() {
    return $this->metricNames;
  }
  public function setPerInteractionDimensions(/* array(BackupGuardGoogle_SortedDimension) */ $perInteractionDimensions) {
    $this->assertIsArray($perInteractionDimensions, 'BackupGuardGoogle_SortedDimension', __METHOD__);
    $this->perInteractionDimensions = $perInteractionDimensions;
  }
  public function getPerInteractionDimensions() {
    return $this->perInteractionDimensions;
  }
  public function setReportProperties(BackupGuardGoogle_ReportPathToConversionCriteriaReportProperties $reportProperties) {
    $this->reportProperties = $reportProperties;
  }
  public function getReportProperties() {
    return $this->reportProperties;
  }
}

class BackupGuardGoogle_ReportPathToConversionCriteriaReportProperties extends BackupGuardGoogle_Model {
  public $clicksLookbackWindow;
  public $impressionsLookbackWindow;
  public $includeAttributedIPConversions;
  public $includeUnattributedCookieConversions;
  public $includeUnattributedIPConversions;
  public $maximumClickInteractions;
  public $maximumImpressionInteractions;
  public $maximumInteractionGap;
  public $pivotOnInteractionPath;
  public function setClicksLookbackWindow( $clicksLookbackWindow) {
    $this->clicksLookbackWindow = $clicksLookbackWindow;
  }
  public function getClicksLookbackWindow() {
    return $this->clicksLookbackWindow;
  }
  public function setImpressionsLookbackWindow( $impressionsLookbackWindow) {
    $this->impressionsLookbackWindow = $impressionsLookbackWindow;
  }
  public function getImpressionsLookbackWindow() {
    return $this->impressionsLookbackWindow;
  }
  public function setIncludeAttributedIPConversions( $includeAttributedIPConversions) {
    $this->includeAttributedIPConversions = $includeAttributedIPConversions;
  }
  public function getIncludeAttributedIPConversions() {
    return $this->includeAttributedIPConversions;
  }
  public function setIncludeUnattributedCookieConversions( $includeUnattributedCookieConversions) {
    $this->includeUnattributedCookieConversions = $includeUnattributedCookieConversions;
  }
  public function getIncludeUnattributedCookieConversions() {
    return $this->includeUnattributedCookieConversions;
  }
  public function setIncludeUnattributedIPConversions( $includeUnattributedIPConversions) {
    $this->includeUnattributedIPConversions = $includeUnattributedIPConversions;
  }
  public function getIncludeUnattributedIPConversions() {
    return $this->includeUnattributedIPConversions;
  }
  public function setMaximumClickInteractions( $maximumClickInteractions) {
    $this->maximumClickInteractions = $maximumClickInteractions;
  }
  public function getMaximumClickInteractions() {
    return $this->maximumClickInteractions;
  }
  public function setMaximumImpressionInteractions( $maximumImpressionInteractions) {
    $this->maximumImpressionInteractions = $maximumImpressionInteractions;
  }
  public function getMaximumImpressionInteractions() {
    return $this->maximumImpressionInteractions;
  }
  public function setMaximumInteractionGap( $maximumInteractionGap) {
    $this->maximumInteractionGap = $maximumInteractionGap;
  }
  public function getMaximumInteractionGap() {
    return $this->maximumInteractionGap;
  }
  public function setPivotOnInteractionPath( $pivotOnInteractionPath) {
    $this->pivotOnInteractionPath = $pivotOnInteractionPath;
  }
  public function getPivotOnInteractionPath() {
    return $this->pivotOnInteractionPath;
  }
}

class BackupGuardGoogle_ReportReachCriteria extends BackupGuardGoogle_Model {
  protected $__activitiesType = 'BackupGuardGoogle_Activities';
  protected $__activitiesDataType = '';
  public $activities;
  protected $__customRichMediaEventsType = 'BackupGuardGoogle_CustomRichMediaEvents';
  protected $__customRichMediaEventsDataType = '';
  public $customRichMediaEvents;
  protected $__dateRangeType = 'BackupGuardGoogle_DateRange';
  protected $__dateRangeDataType = '';
  public $dateRange;
  protected $__dimensionFiltersType = 'BackupGuardGoogle_DimensionValue';
  protected $__dimensionFiltersDataType = 'array';
  public $dimensionFilters;
  protected $__dimensionsType = 'BackupGuardGoogle_SortedDimension';
  protected $__dimensionsDataType = 'array';
  public $dimensions;
  public $metricNames;
  public $reachByFrequencyMetricNames;
  public function setActivities(BackupGuardGoogle_Activities $activities) {
    $this->activities = $activities;
  }
  public function getActivities() {
    return $this->activities;
  }
  public function setCustomRichMediaEvents(BackupGuardGoogle_CustomRichMediaEvents $customRichMediaEvents) {
    $this->customRichMediaEvents = $customRichMediaEvents;
  }
  public function getCustomRichMediaEvents() {
    return $this->customRichMediaEvents;
  }
  public function setDateRange(BackupGuardGoogle_DateRange $dateRange) {
    $this->dateRange = $dateRange;
  }
  public function getDateRange() {
    return $this->dateRange;
  }
  public function setDimensionFilters(/* array(BackupGuardGoogle_DimensionValue) */ $dimensionFilters) {
    $this->assertIsArray($dimensionFilters, 'BackupGuardGoogle_DimensionValue', __METHOD__);
    $this->dimensionFilters = $dimensionFilters;
  }
  public function getDimensionFilters() {
    return $this->dimensionFilters;
  }
  public function setDimensions(/* array(BackupGuardGoogle_SortedDimension) */ $dimensions) {
    $this->assertIsArray($dimensions, 'BackupGuardGoogle_SortedDimension', __METHOD__);
    $this->dimensions = $dimensions;
  }
  public function getDimensions() {
    return $this->dimensions;
  }
  public function setMetricNames(/* array(BackupGuardGoogle_string) */ $metricNames) {
    $this->assertIsArray($metricNames, 'BackupGuardGoogle_string', __METHOD__);
    $this->metricNames = $metricNames;
  }
  public function getMetricNames() {
    return $this->metricNames;
  }
  public function setReachByFrequencyMetricNames(/* array(BackupGuardGoogle_string) */ $reachByFrequencyMetricNames) {
    $this->assertIsArray($reachByFrequencyMetricNames, 'BackupGuardGoogle_string', __METHOD__);
    $this->reachByFrequencyMetricNames = $reachByFrequencyMetricNames;
  }
  public function getReachByFrequencyMetricNames() {
    return $this->reachByFrequencyMetricNames;
  }
}

class BackupGuardGoogle_ReportSchedule extends BackupGuardGoogle_Model {
  public $active;
  public $every;
  public $expirationDate;
  public $repeats;
  public $repeatsOnWeekDays;
  public $runsOnDayOfMonth;
  public $startDate;
  public function setActive( $active) {
    $this->active = $active;
  }
  public function getActive() {
    return $this->active;
  }
  public function setEvery( $every) {
    $this->every = $every;
  }
  public function getEvery() {
    return $this->every;
  }
  public function setExpirationDate( $expirationDate) {
    $this->expirationDate = $expirationDate;
  }
  public function getExpirationDate() {
    return $this->expirationDate;
  }
  public function setRepeats( $repeats) {
    $this->repeats = $repeats;
  }
  public function getRepeats() {
    return $this->repeats;
  }
  public function setRepeatsOnWeekDays(/* array(BackupGuardGoogle_string) */ $repeatsOnWeekDays) {
    $this->assertIsArray($repeatsOnWeekDays, 'BackupGuardGoogle_string', __METHOD__);
    $this->repeatsOnWeekDays = $repeatsOnWeekDays;
  }
  public function getRepeatsOnWeekDays() {
    return $this->repeatsOnWeekDays;
  }
  public function setRunsOnDayOfMonth( $runsOnDayOfMonth) {
    $this->runsOnDayOfMonth = $runsOnDayOfMonth;
  }
  public function getRunsOnDayOfMonth() {
    return $this->runsOnDayOfMonth;
  }
  public function setStartDate( $startDate) {
    $this->startDate = $startDate;
  }
  public function getStartDate() {
    return $this->startDate;
  }
}

class BackupGuardGoogle_SortedDimension extends BackupGuardGoogle_Model {
  public $kind;
  public $name;
  public $sortOrder;
  public function setKind( $kind) {
    $this->kind = $kind;
  }
  public function getKind() {
    return $this->kind;
  }
  public function setName( $name) {
    $this->name = $name;
  }
  public function getName() {
    return $this->name;
  }
  public function setSortOrder( $sortOrder) {
    $this->sortOrder = $sortOrder;
  }
  public function getSortOrder() {
    return $this->sortOrder;
  }
}

class BackupGuardGoogle_UserProfile extends BackupGuardGoogle_Model {
  public $accountId;
  public $accountName;
  public $etag;
  public $kind;
  public $profileId;
  public $subAccountId;
  public $subAccountName;
  public $userName;
  public function setAccountId( $accountId) {
    $this->accountId = $accountId;
  }
  public function getAccountId() {
    return $this->accountId;
  }
  public function setAccountName( $accountName) {
    $this->accountName = $accountName;
  }
  public function getAccountName() {
    return $this->accountName;
  }
  public function setEtag( $etag) {
    $this->etag = $etag;
  }
  public function getEtag() {
    return $this->etag;
  }
  public function setKind( $kind) {
    $this->kind = $kind;
  }
  public function getKind() {
    return $this->kind;
  }
  public function setProfileId( $profileId) {
    $this->profileId = $profileId;
  }
  public function getProfileId() {
    return $this->profileId;
  }
  public function setSubAccountId( $subAccountId) {
    $this->subAccountId = $subAccountId;
  }
  public function getSubAccountId() {
    return $this->subAccountId;
  }
  public function setSubAccountName( $subAccountName) {
    $this->subAccountName = $subAccountName;
  }
  public function getSubAccountName() {
    return $this->subAccountName;
  }
  public function setUserName( $userName) {
    $this->userName = $userName;
  }
  public function getUserName() {
    return $this->userName;
  }
}

class BackupGuardGoogle_UserProfileList extends BackupGuardGoogle_Model {
  public $etag;
  protected $__itemsType = 'BackupGuardGoogle_UserProfile';
  protected $__itemsDataType = 'array';
  public $items;
  public $kind;
  public function setEtag( $etag) {
    $this->etag = $etag;
  }
  public function getEtag() {
    return $this->etag;
  }
  public function setItems(/* array(BackupGuardGoogle_UserProfile) */ $items) {
    $this->assertIsArray($items, 'BackupGuardGoogle_UserProfile', __METHOD__);
    $this->items = $items;
  }
  public function getItems() {
    return $this->items;
  }
  public function setKind( $kind) {
    $this->kind = $kind;
  }
  public function getKind() {
    return $this->kind;
  }
}
