<?php

/**
 * @Package: WordPress Plugin
 * @Subpackage: Ultra Portfolio
 * @Since: Ultra Portfolio 1.0
 * @Current Version: Ultra Portfolio 3.1
 * @WordPress Version: 3.5 or above
 * This file is part of Ultra Portofolio WordPress Plugin.
 */
function uport_scripts() {
    global $wp_version;
    $plug = trim(get_current_screen()->id);

    if ($plug == "toplevel_page_uport" ||
            $plug == "ultra-portfolio_page_uport_items_page" ||
            $plug == "ultra-portfolio_page_uport_edit_portfolio" ||
            $plug == "ultra-portfolio_page_uport_add_new_item" ||
            $plug == "ultra-portfolio_page_uport_categories" ||
            $plug == "ultra-portfolio_page_uport_add_new_category") {

        wp_register_script('uport-jquery.ui.elements', plugins_url('/../js/uport-jquery.ui.elements.js', __FILE__), array('jquery'));
        wp_enqueue_script('uport-jquery.ui.elements');


        wp_enqueue_script('wp-color-picker');
        wp_enqueue_style('wp-color-picker');

        wp_register_script('uport-live-preivew', plugins_url('/../js/uport-live-preview.js', __FILE__), array('jquery', 'wp-color-picker' , 'uport-admin-functions'));
        wp_enqueue_script('uport-live-preivew');


        wp_register_style('uport_jqueryui', plugins_url('/../css/jquery-ui/minified/jquery-ui.min.css', __FILE__));
        wp_enqueue_style('uport_jqueryui');

        wp_register_style('uport_maincss', plugins_url('/../src/uport_template.min.css', __FILE__));
        wp_enqueue_style('uport_maincss');

        /* load scripts */
        wp_register_script('uport_mixitub', plugins_url('/../src/jquery.mixitub.js', __FILE__), array('jquery'));
        wp_enqueue_script('uport_mixitub');

        wp_register_script('uport_isojs', plugins_url('/../src/uport_isotobe.js', __FILE__), array('jquery'));
        wp_enqueue_script('uport_isojs');
        wp_register_style('uport_isocss', plugins_url('/../src/uport_isotobe.min.css', __FILE__));
        wp_enqueue_style('uport_isocss');

        wp_register_script('uport_owljs', plugins_url('/../src/owl.carousel.min.js', __FILE__), array('jquery'));
        wp_enqueue_script('uport_owljs');
        wp_register_style('uport_owlcss', plugins_url('/../src/owl.carousel.min.css', __FILE__));
        wp_enqueue_style('uport_owlcss');
        wp_register_style('uport_owlthemecss', plugins_url('/../src/owl.theme.min.css', __FILE__));
        wp_enqueue_style('uport_owlthemecss');


        wp_register_style('uport_admincss', plugins_url('/../css/uport_admincss.min.css', __FILE__));
        wp_enqueue_style('uport_admincss');
        wp_register_style('uport_iconscss', plugins_url('/../css/uport_icons.min.css', __FILE__));
        wp_enqueue_style('uport_iconscss');

        wp_register_script('uport_fancypox', plugins_url('/../src/fancypox/jquery.fancypox.js', __FILE__), array('jquery'));
        wp_enqueue_script('uport_fancypox');
        wp_register_style('uport_fancypoxcss', plugins_url('/../src/fancypox/jquery.fancypox.min.css', __FILE__));
        wp_enqueue_style('uport_fancypoxcss');
        wp_register_script('uport_fancypox_media', plugins_url('/../src/fancypox/helpers/jquery.fancypox-media.js', __FILE__), array('jquery'));
        wp_enqueue_script('uport_fancypox_media');


        wp_enqueue_script('jquery');
        wp_enqueue_script('media-upload');
        wp_enqueue_script('thickbox');
        wp_register_script('uport-admin-functions', plugins_url('/../js/uport-admin-functions.js', __FILE__), array('jquery', 'media-upload', 'thickbox'));
        wp_enqueue_script('uport-admin-functions');
        wp_enqueue_style('thickbox');
        //wp_enqueue_script('jquery-ui-datepicker');

        wp_localize_script('uport-live-preivew', 'uport_vars', array(
            'uport_nonce' => wp_create_nonce('uport-nonce')
                )
        );
    }
}

function uport_site_scripts() {

    global $wp_version;
    wp_register_style('uport_maincss', plugins_url('/../src/uport_template.min.css', __FILE__));
    wp_enqueue_style('uport_maincss');

    wp_register_script('uport_mixitub', plugins_url('/../src/jquery.mixitub.js', __FILE__), array('jquery'));
    wp_enqueue_script('uport_mixitub');
    wp_register_style('uport_iconscss', plugins_url('/../css/uport_icons.min.css', __FILE__));
    wp_enqueue_style('uport_iconscss');


        wp_register_script('uport_isojs', plugins_url('/../src/uport_isotobe.js', __FILE__), array('jquery'));
        wp_enqueue_script('uport_isojs');
        wp_register_style('uport_isocss', plugins_url('/../src/uport_isotobe.min.css', __FILE__));
        wp_enqueue_style('uport_isocss');

        wp_register_script('uport_owljs', plugins_url('/../src/owl.carousel.min.js', __FILE__), array('jquery'));
        wp_enqueue_script('uport_owljs');
        wp_register_style('uport_owlcss', plugins_url('/../src/owl.carousel.min.css', __FILE__));
        wp_enqueue_style('uport_owlcss');
        wp_register_style('uport_owlthemecss', plugins_url('/../src/owl.theme.min.css', __FILE__));
        wp_enqueue_style('uport_owlthemecss');




    wp_register_script('uport_fancypox', plugins_url('/../src/fancypox/jquery.fancypox.js', __FILE__), array('jquery'));
    wp_enqueue_script('uport_fancypox');
    wp_register_style('uport_fancypoxcss', plugins_url('/../src/fancypox/jquery.fancypox.min.css', __FILE__));
    wp_enqueue_style('uport_fancypoxcss');
    wp_register_script('uport_fancypox_media', plugins_url('/../src/fancypox/helpers/jquery.fancypox-media.js', __FILE__), array('jquery'));
    wp_enqueue_script('uport_fancypox_media');
}

add_action('admin_enqueue_scripts', 'uport_scripts');

add_action('wp_enqueue_scripts', 'uport_site_scripts');
?>